/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.api.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.ow2.petals.component.framework.api.configuration.ConfigurationElementCardinality;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.util.PropertiesUtil;
import org.ow2.petals.component.framework.jbidescriptor.generated.Param;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationExtensions
implements Map<String, String> {
    private final Map<String, String> extensions = new ConcurrentHashMap<String, String>();
    private Properties properties;

    public ConfigurationExtensions(List<?> configurationElements, String propertiesFilePath) throws PEtALSCDKException {
        this(configurationElements);
        if (propertiesFilePath != null) {
            this.properties = PropertiesUtil.loadProperties(propertiesFilePath);
            PropertiesUtil.fillPlaceHolder(this.properties, this.extensions);
        }
    }

    public ConfigurationExtensions(List<?> configurationElements) {
        if (configurationElements != null && !configurationElements.isEmpty()) {
            List<ConfigurationElementCardinality> cardinalitiesList = ConfigurationExtensions.getMultipleElements(configurationElements);
            for (Object configurationElement : configurationElements) {
                boolean isFound = false;
                for (ConfigurationElementCardinality elementCardinality : cardinalitiesList) {
                    if (!elementCardinality.name.equals(ConfigurationExtensions.getCfgEltName(configurationElement))) continue;
                    ++elementCardinality.suffixNumber;
                    this.extensions.put(elementCardinality.name + Integer.valueOf(elementCardinality.suffixNumber), ConfigurationExtensions.getCfgEltValue(configurationElement));
                    isFound = true;
                }
                if (isFound) continue;
                this.extensions.put(ConfigurationExtensions.getCfgEltName(configurationElement), ConfigurationExtensions.getCfgEltValue(configurationElement));
            }
        }
    }

    @Override
    public void clear() {
        this.extensions.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.extensions.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.extensions.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.extensions.entrySet();
    }

    @Override
    public String get(Object key) {
        return this.extensions.get(key);
    }

    public String get(Object key, String defaultValue) {
        String result = this.get(key);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.extensions.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.extensions.keySet();
    }

    @Override
    public String put(String key, String value) {
        if (this.properties != null) {
            PropertiesUtil.fillPlaceHolder(value, PropertiesUtil.extractPlaceHolderKeys(key), this.properties);
        }
        return this.extensions.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> map) {
        if (this.properties != null) {
            PropertiesUtil.fillPlaceHolder(this.properties, map);
        }
        this.extensions.putAll(map);
    }

    @Override
    public String remove(Object key) {
        return this.extensions.remove(key);
    }

    @Override
    public int size() {
        return this.extensions.size();
    }

    @Override
    public Collection<String> values() {
        return this.extensions.values();
    }

    private static final String getCfgEltName(Object configurationElement) {
        String sRes = null;
        if (configurationElement instanceof Element) {
            sRes = ((Element)configurationElement).getLocalName();
        } else if (configurationElement instanceof Param) {
            sRes = ((Param)configurationElement).getName();
        }
        return sRes;
    }

    private static final String getCfgEltValue(Object configurationElement) {
        String sRes = null;
        if (configurationElement instanceof Element) {
            sRes = ((Element)configurationElement).getTextContent();
        } else if (configurationElement instanceof Param) {
            sRes = ((Param)configurationElement).getValue();
        }
        return sRes;
    }

    private static final List<ConfigurationElementCardinality> getMultipleElements(List<?> configurationElements) {
        ArrayList<ConfigurationElementCardinality> cardinalitiesList = new ArrayList<ConfigurationElementCardinality>();
        for (Object configurationElement : configurationElements) {
            boolean isFound = false;
            for (ConfigurationElementCardinality elementCardinality : cardinalitiesList) {
                if (!elementCardinality.name.equals(ConfigurationExtensions.getCfgEltName(configurationElement))) continue;
                ++elementCardinality.cardinality;
                isFound = true;
                break;
            }
            if (isFound) continue;
            ConfigurationElementCardinality elementCardinality = new ConfigurationElementCardinality();
            elementCardinality.name = ConfigurationExtensions.getCfgEltName(configurationElement);
            cardinalitiesList.add(elementCardinality);
        }
        ArrayList<ConfigurationElementCardinality> cardinalitiesList2 = new ArrayList<ConfigurationElementCardinality>();
        for (ConfigurationElementCardinality elementCardinality : cardinalitiesList) {
            if (elementCardinality.cardinality <= 1) continue;
            cardinalitiesList2.add(elementCardinality);
        }
        return cardinalitiesList2;
    }

    public String toString() {
        return this.extensions.toString();
    }
}

