/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.mbean;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;
import javax.management.ObjectName;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.Component;
import org.ow2.petals.component.framework.api.Interceptor;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.interceptor.MessageInterceptorManager;
import org.ow2.petals.component.framework.interceptor.description.InterceptorBuilder;
import org.ow2.petals.component.framework.jbidescriptor.CDKJBIDescriptorException;
import org.ow2.petals.component.framework.jbidescriptor.JBIDescriptorBuilder;
import org.ow2.petals.component.framework.jbidescriptor.generated.ComponentInterceptor;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.mbean.InterceptorManagerMBean;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;

public class InterceptorManager
implements InterceptorManagerMBean {
    private AbstractComponent component;
    private Logger logger;
    private ObjectName mBeanName;
    private Jbi jbiComponentConfiguration;
    private File jbiComponentFile;

    public InterceptorManager(AbstractComponent component, Jbi jbiComponentConfiguration, File jbiComponentFile) {
        this.component = component;
        this.jbiComponentConfiguration = jbiComponentConfiguration;
        this.jbiComponentFile = jbiComponentFile;
        this.logger = component.getLogger();
    }

    public void addInterceptor(String className, String interceptorName) throws MBeanException {
        this.logger.log(Level.INFO, "Add interceptor " + interceptorName);
        if (this.component.getInterceptor(interceptorName) != null) {
            throw new MBeanException(new Exception("This interceptor is already registered"));
        }
        Interceptor itc = null;
        try {
            itc = InterceptorBuilder.loadInstance(className);
            itc.init((Component)this.component, interceptorName, false, new HashMap(), this.logger);
        }
        catch (PEtALSCDKException e) {
            throw new MBeanException((Exception)((Object)e));
        }
        ComponentInterceptor componentInterceptor = new ComponentInterceptor();
        componentInterceptor.setActive(false);
        componentInterceptor.setClazz(className);
        componentInterceptor.setName(interceptorName);
        Map<String, Interceptor> interceptors = this.component.getInterceptors();
        interceptors.put(interceptorName, itc);
        List componentInterceptors = this.component.getComponentConfiguration().getComponentInterceptors().getInterceptor();
        componentInterceptors.add(componentInterceptor);
        this.save();
    }

    public void engageInterceptor(String interceptorName) throws MBeanException {
        this.logger.log(Level.INFO, "Engage interceptor " + interceptorName);
        Interceptor interceptor = this.component.getInterceptor(interceptorName);
        if (interceptor == null) {
            throw new MBeanException(new Exception("Failed to retrieve interceptor named '" + interceptorName + "'"));
        }
        if (!interceptor.isActive()) {
            AbstractServiceUnitManager suManager = (AbstractServiceUnitManager)this.component.getServiceUnitManager();
            for (ServiceUnitDataHandler suDataHandler : suManager.getServiceUnitDataHandlers().values()) {
                for (MessageInterceptorManager manager : suDataHandler.getMessageInterceptorManagersMap().values()) {
                    manager.addGlobalInterceptor(interceptor);
                }
            }
            interceptor.setActive(true);
            List componentInterceptors = this.component.getComponentConfiguration().getComponentInterceptors().getInterceptor();
            for (ComponentInterceptor componentInterceptor : componentInterceptors) {
                if (!componentInterceptor.getName().equals(interceptor.getName())) continue;
                componentInterceptor.setActive(true);
                this.save();
                break;
            }
        }
    }

    public void setMBeanName(ObjectName mbeanName) {
        this.mBeanName = mbeanName;
    }

    public ObjectName getMBeanName() {
        return this.mBeanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        try {
            FileOutputStream outputStream = new FileOutputStream(this.jbiComponentFile);
            try {
                JBIDescriptorBuilder.buildXmlJBIdescriptor((Jbi)this.jbiComponentConfiguration, (OutputStream)outputStream);
                Object var3_4 = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                outputStream.close();
                throw throwable;
            }
            outputStream.close();
            {
            }
        }
        catch (CDKJBIDescriptorException e) {
            this.logger.warning("Failed to pesist modification of the Interceptor manager MBean : " + ((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage());
        }
        catch (IOException e) {
            this.logger.warning("Failed to pesist modification of the Interceptor manager MBean : " + e.getClass().getSimpleName() + " : " + e.getMessage());
        }
    }
}

