/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.nio.charset.Charset;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.ow2.petals.commons.stream.InputStreamForker;
import org.ow2.petals.commons.stream.ReaderInputStream;
import org.ow2.petals.commons.threadlocal.DocumentBuilders;
import org.ow2.petals.commons.threadlocal.Transformers;
import org.ow2.petals.component.framework.api.exception.DocumentException;
import org.ow2.petals.component.framework.api.exception.FaultException;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.util.SourceUtil;
import org.ow2.petals.component.framework.util.StringHelper;
import org.ow2.petals.component.framework.util.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SourceUtilImpl
implements SourceUtil {
    private static final String SOAPENV_NAMESPACE = "http://schemas.xmlsoap.org/soap/envelope/";

    private static final InputStream forkStreamSource(StreamSource streamSource) {
        InputStream isContent = streamSource.getInputStream();
        InputStreamForker streamForker = isContent != null ? new InputStreamForker(isContent) : new InputStreamForker((InputStream)new ReaderInputStream(streamSource.getReader()));
        streamSource.setInputStream(streamForker.getInputStreamOne());
        return streamForker.getInputStreamTwo();
    }

    public Document createDocument(Source source) throws PEtALSCDKException {
        return this.createDocument(source, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document createDocument(Source source, boolean forkSource) throws PEtALSCDKException {
        Document document;
        block12: {
            document = null;
            try {
                if (source instanceof DOMSource) {
                    Node originalNode = ((DOMSource)source).getNode();
                    if (originalNode instanceof Document) {
                        Document originalDocument = (Document)originalNode;
                        if (forkSource) {
                            document = DocumentBuilders.getNamespaceDocumentBuilder().newDocument();
                            document.appendChild(document.importNode(originalDocument.getDocumentElement(), true));
                        } else {
                            document = originalDocument;
                        }
                    } else {
                        document = DocumentBuilders.getNamespaceDocumentBuilder().newDocument();
                        if (forkSource) {
                            document.appendChild(document.importNode(originalNode, true));
                        } else {
                            document.appendChild(document.adoptNode(originalNode));
                        }
                    }
                }
                if (document != null) break block12;
                Source tempSource = source;
                if (forkSource && source instanceof StreamSource) {
                    tempSource = new StreamSource(SourceUtilImpl.forkStreamSource((StreamSource)source));
                }
                document = DocumentBuilders.getNamespaceDocumentBuilder().newDocument();
                DOMResult domResult = new DOMResult(document);
                Transformer transformer = Transformers.getDefaultTransformer();
                try {
                    transformer.transform(tempSource, domResult);
                    Object var8_8 = null;
                    transformer.reset();
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    transformer.reset();
                    throw throwable;
                }
            }
            catch (TransformerException e) {
                throw new PEtALSCDKException((Throwable)e);
            }
        }
        return document;
    }

    public DOMSource createDOMSource(Document document) {
        document.normalizeDocument();
        return new DOMSource(document);
    }

    public Document createSoapFaultDocument(Throwable e, QName errorCode) {
        PrintWriter pw;
        StringWriter sw;
        QName faultCode = errorCode;
        String faultString = e.getMessage();
        if (faultString == null) {
            faultString = "null message";
        }
        String details = "";
        URI faultActor = null;
        if (e instanceof DocumentException) {
            faultCode = ((DocumentException)e).getFaultCode();
            faultActor = ((DocumentException)e).getFaultActor();
            Document document = ((DocumentException)e).getDocument();
            if (document != null && document.getDocumentElement() != null) {
                try {
                    details = XMLUtil.parseToString(document.getDocumentElement());
                }
                catch (TransformerException e1) {
                    details = "An error occured when retrieving the exception document (" + e1.getMessage() + ").";
                }
            }
        } else if (e instanceof FaultException) {
            faultCode = ((FaultException)e).getFaultCode();
            faultActor = ((FaultException)e).getFaultActor();
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            details = sw.toString();
        } else {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            details = sw.toString();
        }
        Document faultDocument = DocumentBuilders.getNamespaceDocumentBuilder().newDocument();
        Element faultElement = faultDocument.createElementNS(SOAPENV_NAMESPACE, "soapenv:Fault");
        if (!this.isDOM3(faultDocument)) {
            Attr attr = faultDocument.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:soapenv");
            attr.appendChild(faultDocument.createTextNode(SOAPENV_NAMESPACE));
            faultElement.setAttributeNode(attr);
        }
        faultDocument.appendChild(faultElement);
        Element faultCodeElement = faultDocument.createElement("faultcode");
        if (faultCode != null) {
            if (faultCode.getNamespaceURI() != null) {
                if (faultCode.getNamespaceURI().equals(SOAPENV_NAMESPACE)) {
                    faultCodeElement.appendChild(faultDocument.createTextNode("soapenv:" + faultCode.getLocalPart()));
                } else {
                    String faultCodePrefix = faultCode.getPrefix();
                    if (StringHelper.isNullOrEmpty(faultCodePrefix)) {
                        faultCodePrefix = "fcns";
                    }
                    Attr attr = faultDocument.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + faultCodePrefix);
                    attr.appendChild(faultDocument.createTextNode(faultCode.getNamespaceURI()));
                    faultCodeElement.setAttributeNode(attr);
                    faultCodeElement.appendChild(faultDocument.createTextNode(faultCodePrefix + ":" + faultCode.getLocalPart()));
                }
            } else {
                faultCodeElement.appendChild(faultDocument.createTextNode(faultCode.getLocalPart()));
            }
        }
        Element faultStringElement = faultDocument.createElement("faultstring");
        faultStringElement.appendChild(faultDocument.createCDATASection(faultString));
        Element faultDetailElement = faultDocument.createElement("detail");
        if (e instanceof DocumentException) {
            faultDetailElement.appendChild(faultDocument.createCDATASection(details));
        } else {
            Element stackTrace = faultDocument.createElement("stackTrace");
            faultDetailElement.appendChild(stackTrace);
            stackTrace.appendChild(faultDocument.createCDATASection(details));
        }
        Element faultActorElement = faultDocument.createElement("faultactor");
        if (faultActor != null) {
            faultActorElement.appendChild(faultDocument.createTextNode(faultActor.toString()));
        }
        faultElement.appendChild(faultCodeElement);
        faultElement.appendChild(faultStringElement);
        faultElement.appendChild(faultActorElement);
        faultElement.appendChild(faultDetailElement);
        return faultDocument;
    }

    public Source createSource(String message) throws PEtALSCDKException {
        String charsetEncoding = Charset.defaultCharset().displayName();
        return this.createSource(message, charsetEncoding);
    }

    public Source createSource(String message, String charFormat) throws PEtALSCDKException {
        StreamSource source = new StreamSource();
        try {
            byte[] msgByte = message.getBytes(charFormat);
            ByteArrayInputStream in = new ByteArrayInputStream(msgByte);
            source.setInputStream(in);
        }
        catch (IOException e) {
            throw new PEtALSCDKException((Throwable)e);
        }
        return source;
    }

    public StreamSource createStreamSource(Document document) throws PEtALSCDKException {
        ByteArrayOutputStream bufferOut = new ByteArrayOutputStream();
        StreamResult sResult = new StreamResult(bufferOut);
        Transformer transformer = Transformers.getDefaultTransformer();
        try {
            try {
                transformer.transform(new DOMSource(document), sResult);
            }
            catch (TransformerException e) {
                throw new PEtALSCDKException("Error while transform DOM2 document to StreamSource", (Throwable)e);
            }
            Object var7_5 = null;
            transformer.reset();
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            transformer.reset();
            throw throwable;
        }
        ByteArrayInputStream bufferIn = new ByteArrayInputStream(bufferOut.toByteArray());
        return new StreamSource(bufferIn);
    }

    public String createString(Source source) throws PEtALSCDKException {
        return this.createString(source, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createString(Source source, boolean forkSource) throws PEtALSCDKException {
        Source tempSource = source;
        if (forkSource && source instanceof StreamSource) {
            tempSource = new StreamSource(SourceUtilImpl.forkStreamSource((StreamSource)source));
        }
        try {
            StringWriter buffer = new StringWriter();
            StreamResult sresult = new StreamResult(buffer);
            Transformer transformer = Transformers.getDefaultTransformer();
            try {
                transformer.transform(tempSource, sresult);
                Object var8_9 = null;
                transformer.reset();
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                transformer.reset();
                throw throwable;
            }
            return buffer.toString();
        }
        catch (TransformerConfigurationException e) {
            throw new PEtALSCDKException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new PEtALSCDKException((Throwable)e);
        }
    }

    public boolean isDOM3(Document document) {
        boolean result = true;
        try {
            document.getClass().getMethod("getBaseURI", null);
        }
        catch (NoSuchMethodException e) {
            result = false;
        }
        return result;
    }
}

