/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.api.util;

import java.net.URI;
import javax.xml.namespace.QName;
import org.petalslink.dsb.api.ServiceEndpoint;

public class EndpointHelper {
    public static final String DSB_PREFIX = "dsb";
    public static final String JAVA_PREFIX = "java";

    private EndpointHelper() {
    }

    public static boolean isDSBService(String uri) {
        return uri != null && uri.startsWith("dsb://");
    }

    public static boolean isDSBService(URI uri) {
        return uri != null && uri.toString().startsWith("dsb://");
    }

    public static boolean isJavaService(URI uri) {
        return uri != null && uri.toString().startsWith("java://");
    }

    public static ServiceEndpoint getServiceEndpoint(URI uri) {
        ServiceEndpoint result = null;
        if (uri == null || !EndpointHelper.isDSBService(uri)) {
            return null;
        }
        result = new ServiceEndpoint();
        result.setEndpointName(EndpointHelper.getEndpoint(uri));
        result.setServiceName(EndpointHelper.getService(uri));
        return result;
    }

    public static QName getService(URI uri) {
        if (uri == null || !EndpointHelper.isDSBService(uri)) {
            return null;
        }
        String tmp = uri.toString();
        String serviceName = null;
        if (!tmp.contains("@")) {
            return null;
        }
        serviceName = tmp.substring("dsb://".length(), tmp.indexOf(64));
        String ns = "http://" + serviceName.substring(0, serviceName.lastIndexOf(47) + 1);
        String localPart = serviceName.substring(serviceName.lastIndexOf(47) + 1);
        return new QName(ns, localPart);
    }

    public static String getEndpoint(URI uri) {
        if (uri == null || !EndpointHelper.isDSBService(uri)) {
            return null;
        }
        String tmp = uri.toString();
        String endpointName = null;
        if (!tmp.contains("@")) {
            return null;
        }
        endpointName = tmp.substring(tmp.indexOf(64) + 1);
        return endpointName;
    }
}

