/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.restproxy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.petals.binding.restproxy.Component;
import org.ow2.petals.binding.restproxy.in.RESTEngineContext;
import org.ow2.petals.component.framework.ComponentInformation;
import org.ow2.petals.component.framework.PetalsBindingComponent;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.su.BindingComponentServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;
import org.ow2.petals.messaging.framework.Engine;
import org.ow2.petals.messaging.framework.EngineFactory;

public class SUManager
extends BindingComponentServiceUnitManager {
    private final Map<String, Jbi> cache = new HashMap<String, Jbi>();

    public SUManager(Component bindingComponent) {
        super(bindingComponent);
    }

    public ComponentInformation getComponentInformation() {
        return ((PetalsBindingComponent)this.component).getPlugin(ComponentInformation.class);
    }

    protected void doDeploy(String serviceUnitName, String suRootPath, Jbi jbiDescriptor) throws PEtALSCDKException {
        List consumes = jbiDescriptor.getServices().getConsumes();
        for (Consumes consumes2 : consumes) {
            this.deployConsume(consumes2);
        }
        List provides = jbiDescriptor.getServices().getProvides();
        for (Provides provides2 : provides) {
            this.deployProvide(provides2);
        }
        this.cache.put(serviceUnitName, jbiDescriptor);
    }

    private void deployProvide(Provides provides2) {
        ServiceUnitDataHandler dh = this.getSUDataHandlerForProvides(provides2);
        ConfigurationExtensions extensions = dh.getConfigurationExtensions(provides2);
        String restService = extensions.get((Object)"address");
        if (restService != null) {
            this.addToConsume(restService);
        }
    }

    private void deployConsume(Consumes consumes2) {
        ConfigurationExtensions extensions;
        String restService;
        Engine engine = EngineFactory.getEngine();
        RESTEngineContext context = (RESTEngineContext)engine.getComponent(RESTEngineContext.class);
        if (context == null) {
            return;
        }
        RESTEngineContext.Consume consume = context.newConsume();
        consume.setEndpointName(consumes2.getEndpointName());
        consume.setInterfaceName(consumes2.getInterfaceName());
        consume.setServiceName(consumes2.getServiceName());
        ServiceUnitDataHandler dh = this.getSUDataHandlerForConsumes(consumes2);
        if (dh != null && (restService = (extensions = dh.getConfigurationExtensions(consumes2)).get((Object)"address")) != null) {
            Engine e = EngineFactory.getEngine();
            RESTEngineContext restEngineContext = (RESTEngineContext)e.getComponent(RESTEngineContext.class);
            String serviceURL = "http://$HOST:" + restEngineContext.getPort() + restEngineContext.getServicePath() + "/" + restService;
            this.addToExpose(serviceURL);
            context.getRestConsumers().put(restService, consume);
        }
    }

    private void addToExpose(String restService) {
        if (this.getComponentInformation() == null) {
            return;
        }
        Set<String> exposed = this.getComponentInformation().getExposedServices();
        if (exposed != null) {
            exposed.add(restService);
        }
    }

    private void removeFromExpose(String restService) {
        if (this.getComponentInformation() == null) {
            return;
        }
        Set<String> exposed = this.getComponentInformation().getExposedServices();
        if (exposed != null) {
            exposed.remove(restService);
        }
    }

    private void addToConsume(String restService) {
        if (this.getComponentInformation() == null) {
            return;
        }
        Set<String> services = this.getComponentInformation().getConsumedServices();
        if (services != null) {
            services.add(restService);
        }
    }

    private void removeFromConsume(String restService) {
        if (this.getComponentInformation() == null) {
            return;
        }
        Set<String> services = this.getComponentInformation().getConsumedServices();
        if (services != null) {
            services.remove(restService);
        }
    }

    protected void doInit(String serviceUnitName, String suRootPath) throws PEtALSCDKException {
    }

    protected void doShutdown(String serviceUnitName) throws PEtALSCDKException {
    }

    protected void doStart(String serviceUnitName) throws PEtALSCDKException {
    }

    protected void doStop(String serviceUnitName) throws PEtALSCDKException {
        Jbi jbiDescriptor = this.cache.get(serviceUnitName);
        if (jbiDescriptor == null) {
            return;
        }
        List consumes = jbiDescriptor.getServices().getConsumes();
        for (Consumes consumes2 : consumes) {
            this.undeployConsume(consumes2);
        }
    }

    private void undeployConsume(Consumes consumes2) {
        ConfigurationExtensions extensions;
        String restService;
        this.logger.fine("Undeploying consume = " + consumes2);
        Engine engine = EngineFactory.getEngine();
        RESTEngineContext context = (RESTEngineContext)engine.getComponent(RESTEngineContext.class);
        if (context == null) {
            return;
        }
        ServiceUnitDataHandler dh = this.getSUDataHandlerForConsumes(consumes2);
        if (dh != null && (restService = (extensions = dh.getConfigurationExtensions(consumes2)).get((Object)"address")) != null) {
            context.getRestConsumers().remove(restService);
        }
    }

    protected void doUndeploy(String serviceUnitName) throws PEtALSCDKException {
    }
}

