/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.restproxy.in;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.ow2.petals.binding.restproxy.IOUtils;
import org.ow2.petals.binding.restproxy.in.RESTEngineContext;
import org.ow2.petals.messaging.framework.Engine;
import org.ow2.petals.messaging.framework.EngineFactory;
import org.ow2.petals.messaging.framework.lifecycle.LifeCycle;
import org.ow2.petals.messaging.framework.lifecycle.LifeCycleException;
import org.ow2.petals.messaging.framework.message.Message;
import org.ow2.petals.messaging.framework.plugins.Service;

public class ListService
implements Service {
    public void invoke(Message message) {
        OutputStream os = (OutputStream)message.getContent(OutputStream.class);
        Engine engine = EngineFactory.getEngine();
        RESTEngineContext context = (RESTEngineContext)engine.getComponent(RESTEngineContext.class);
        if (context == null) {
            return;
        }
        Map<String, RESTEngineContext.Consume> consumes = context.getRestConsumers();
        if (os != null) {
            try {
                os.write("<html><title>REST Services Information</title><body>".getBytes());
                os.write("<h2>Information</h2>".getBytes());
                os.write(("<b>Port</b> : " + context.getPort()).getBytes());
                os.write(("<br><b>Proxy Path</b> : " + context.getProxyPath()).getBytes());
                os.write(("<br><b>Services Path</b> : " + context.getServicePath()).getBytes());
                os.write("<h2>Services</h2>".getBytes());
                os.write("<br><br>".getBytes());
                os.write("<table border='1'><tr><td>REST Service Name</td><td>JBI ServiceName</td><td>JBI Interface Name</td><td>JBI Endpoint Name</td></tr>".getBytes());
                for (String serviceName : consumes.keySet()) {
                    os.write("<tr>".getBytes());
                    os.write(("<td><a href='" + context.getServicePath() + "/" + serviceName + "'>" + serviceName + "</a></td>").getBytes());
                    RESTEngineContext.Consume consume = consumes.get(serviceName);
                    if (consume != null) {
                        os.write(("<td>" + consume.getServiceName() + "</td>").getBytes());
                        os.write(("<td>" + consume.getInterfaceName() + "</td>").getBytes());
                        os.write(("<td>" + consume.getEndpointName() + "</td>").getBytes());
                    } else {
                        os.write("<td>-</td><td>-</td><td>-</td>".getBytes());
                    }
                    os.write("</tr>".getBytes());
                }
                os.write("</table>".getBytes());
                os.write("</body></html>".getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        IOUtils.flushAndCose(os);
    }

    public LifeCycle.STATE getState() {
        return null;
    }

    public void init() throws LifeCycleException {
    }

    public void start() throws LifeCycleException {
    }

    public void stop() throws LifeCycleException {
    }
}

