/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.restproxy.in;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ow2.petals.binding.restproxy.HTTPUtils;
import org.ow2.petals.binding.restproxy.in.AbstractRESTService;
import org.ow2.petals.binding.restproxy.in.RESTEngineContext;
import org.ow2.petals.messaging.framework.EngineException;
import org.ow2.petals.messaging.framework.EngineFactory;
import org.ow2.petals.messaging.framework.lifecycle.LifeCycle;
import org.ow2.petals.messaging.framework.lifecycle.LifeCycleException;
import org.ow2.petals.messaging.framework.message.Message;

public class REST2JBIService
extends AbstractRESTService {
    public void invoke(Message message) throws EngineException {
        RESTEngineContext restEngineContext = (RESTEngineContext)EngineFactory.getEngine().getComponent(RESTEngineContext.class);
        HttpServletRequest request = (HttpServletRequest)message.getContent(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)message.getContent(HttpServletResponse.class);
        if (request == null || response == null) {
            throw new EngineException("Can not find valid HTTP contents (HTTServletResquest or HTTPServletResponse");
        }
        this.updateStats(request, restEngineContext);
        String path = message.get("path") != null ? message.get("path").toString() : "";
        String servicePath = message.get("services") != null ? message.get("services").toString() : "";
        String tmp = HTTPUtils.decode(path, request);
        if (servicePath.endsWith("/")) {
            servicePath = servicePath.substring(0, servicePath.length() - 1);
        }
        if ((tmp = tmp.substring(servicePath.length() + 1, tmp.length())).startsWith("/") && tmp.length() > 1) {
            tmp = tmp.substring(1, tmp.length());
        }
        String serviceName = null;
        String resourcePath = null;
        if (tmp.indexOf(47) >= 0) {
            serviceName = tmp.substring(0, tmp.indexOf(47));
            if (tmp.length() > tmp.indexOf(47)) {
                resourcePath = tmp.substring(tmp.indexOf(47) + 1, tmp.length());
            }
        } else {
            serviceName = tmp;
            resourcePath = "";
        }
        if (request.getQueryString() != null && request.getQueryString().trim().length() > 0) {
            resourcePath = resourcePath + "?" + request.getQueryString();
        }
        this.invoke(serviceName.trim(), resourcePath.trim(), request, response);
    }

    private void updateStats(HttpServletRequest request, RESTEngineContext restEngineContext) {
        String httpMethod = request.getMethod();
        if ("POST".equalsIgnoreCase(httpMethod)) {
            restEngineContext.getRestStats().newPost();
        } else if ("GET".equalsIgnoreCase(httpMethod)) {
            restEngineContext.getRestStats().newGet();
        } else if ("PUT".equalsIgnoreCase(httpMethod)) {
            restEngineContext.getRestStats().newPut();
        } else if ("DELETE".equalsIgnoreCase(httpMethod)) {
            restEngineContext.getRestStats().newDelete();
        } else if ("HEAD".equalsIgnoreCase(httpMethod)) {
            // empty if block
        }
    }

    public LifeCycle.STATE getState() {
        return null;
    }

    public void init() throws LifeCycleException {
    }

    public void start() throws LifeCycleException {
    }

    public void stop() throws LifeCycleException {
    }
}

