/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.restproxy.in.server;

import javax.servlet.Servlet;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.ow2.petals.binding.restproxy.in.RESTEngineContext;
import org.ow2.petals.binding.restproxy.in.server.RESTServlet;
import org.ow2.petals.messaging.framework.Engine;
import org.ow2.petals.messaging.framework.EngineFactory;
import org.ow2.petals.messaging.framework.lifecycle.LifeCycle;
import org.ow2.petals.messaging.framework.lifecycle.LifeCycleException;
import org.ow2.petals.messaging.framework.plugins.Job;

public class RESTServerJob
implements Job {
    private Server jettyServer;

    public String getName() {
        return "RESTServerJob based on Jetty";
    }

    public void start() {
        try {
            this.jettyServer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        try {
            this.jettyServer.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LifeCycle.STATE getState() {
        return null;
    }

    public void init() throws LifeCycleException {
        Engine e = EngineFactory.getEngine();
        RESTEngineContext restEngineContext = (RESTEngineContext)e.getComponent(RESTEngineContext.class);
        int port = 8787;
        if (restEngineContext != null) {
            port = restEngineContext.getPort();
        }
        this.jettyServer = new Server(port);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this.jettyServer.setHandler((Handler)contexts);
        Context restContext = new Context((HandlerContainer)contexts, "/", 1);
        ServletHolder restServlet = new ServletHolder((Servlet)new RESTServlet());
        restServlet.setName("RESTServlet");
        restServlet.setInitOrder(1);
        restContext.addServlet(restServlet, "/*");
    }
}

