/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.restproxy.out;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;
import org.ow2.petals.component.framework.util.XMLUtil;
import org.ow2.petals.messaging.framework.EngineFactory;
import org.ow2.petals.messaging.framework.message.Message;
import org.ow2.petals.messaging.framework.message.MessageImpl;
import org.ow2.petals.messaging.framework.message.MessagingEngine;

public class JBIListener
extends AbstractJBIListener {
    private Logger logger;

    public void init() {
        this.logger = this.getLogger();
    }

    public boolean onJBIMessage(Exchange exchange) {
        if (exchange.isProviderRole()) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("JBI message received on RESTPROXY JBI listener");
            }
            this.invoke(exchange);
        } else {
            this.logger.info("Role not supported in RESTPROXY JBIListener : " + exchange.getRole());
        }
        return true;
    }

    protected void invoke(Exchange exchange) {
        NormalizedMessage in = exchange.getInMessage();
        if (in == null) {
            this.handleError(exchange, "MessageImpl exchange must handle an IN normalized message");
        } else {
            Object o2;
            String address = null;
            Provides provides = this.getProvides();
            if (provides != null) {
                ConfigurationExtensions extensions = this.getExtensions();
                if (extensions != null) {
                    this.logger.fine("Extensions are not null, getting address");
                    address = extensions.get((Object)"address");
                } else {
                    this.logger.fine("Extensions are null");
                }
            } else {
                this.logger.fine("This is not a listener which has been activated from a SU");
            }
            MessageImpl inMessage = new MessageImpl();
            if (in.getPropertyNames() != null) {
                for (Object o2 : in.getPropertyNames()) {
                    String key = o2.toString();
                    inMessage.put(key, (Object)in.getProperty(key).toString());
                }
            }
            QName operation = exchange.getOperation();
            inMessage.put("com.ebmwebsourcing.commons.ws.framework.httpmethod", (Object)operation.getLocalPart());
            o2 = in.getProperty("com.ebmwebsourcing.commons.ws.framework.httpURL");
            if (o2 != null) {
                address = address == null ? o2.toString() : address.trim() + "/" + o2.toString().trim();
            }
            try {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Let's call REST service at : " + address);
                }
                inMessage.setContent(Source.class, (Object)in.getContent());
                inMessage.put("com.ebmwebsourcing.commons.ws.framework.httpURL", (Object)new URL(address));
                inMessage.put("com.ebmwebsourcing.commons.ws.framework.Protocol", (Object)"http");
                MessagingEngine engine = (MessagingEngine)EngineFactory.getEngine().getComponent(MessagingEngine.class);
                Message result = null;
                if (engine != null) {
                    result = engine.send((Message)inMessage);
                }
                if (result != null) {
                    if (result.getContent(Source.class) != null) {
                        exchange.setOutMessageContent((Source)result.getContent(Source.class));
                    } else {
                        exchange.setOutMessageContent(XMLUtil.createDocumentFromString("<empty/>"));
                    }
                    exchange.setOutMessageProperties(result.getAll());
                }
            }
            catch (Exception e) {
                this.handleException(exchange, e);
            }
        }
    }

    protected void handleError(Exchange exchange, String exception) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Handling Error", exception);
        }
        String message = null;
        if (exception == null) {
            message = "The exception generated by the component is unknown";
        }
        exchange.setError((Exception)((Object)new MessagingException("REST PROXY Error => " + message)));
    }

    protected void handleException(Exchange exchange, Exception exception) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Handling Exception", exception);
        }
        String message = null;
        message = exception.getMessage();
        if (message == null && exception.getCause() != null) {
            message = exception.getCause().getMessage();
        }
        if (message == null) {
            message = "The exception generated by the component is unknown";
        }
        exchange.setError((Exception)((Object)new MessagingException("REST PROXY Error => " + message)));
    }
}

