/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.generator.commons;

import com.ebmwebsourcing.commons.jbi.sugenerator.beans.SaBean;
import com.ebmwebsourcing.commons.jbi.sugenerator.beans.SuBean;
import com.ebmwebsourcing.commons.jbi.sugenerator.beans.SuBeanForSa;
import com.ebmwebsourcing.commons.jbi.sugenerator.utils.JbiXmlGenerator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.tools.generator.commons.Creator;
import org.ow2.petals.tools.generator.commons.CreatorFactory;
import org.ow2.petals.tools.generator.commons.GeneratorException;
import org.ow2.petals.tools.generator.commons.JBIUtils;
import org.ow2.petals.tools.generator.jbi.api.JBIGenerationEngine;
import org.ow2.petals.tools.generator.jbi.api.JBIGenerationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGeneratorEngine
implements JBIGenerationEngine {
    private final Log logger = LogFactory.getLog(AbstractGeneratorEngine.class);
    protected File inputFolder;
    protected File outputFolder;
    protected SaBean saBean;
    protected List<SuBeanForSa> suBeans;
    protected String componentVersion;
    protected Creator creator;
    protected Map<String, String> extensions;

    public AbstractGeneratorEngine(File inputFolder, File outputFolder, String componentVersion, Map<String, String> extensions) {
        this.inputFolder = inputFolder;
        this.outputFolder = outputFolder;
        this.componentVersion = componentVersion;
        this.extensions = extensions != null ? extensions : new HashMap<String, String>();
        this.saBean = new SaBean();
        this.suBeans = new ArrayList<SuBeanForSa>(1);
    }

    /*
     * Unable to fully structure code
     */
    public File generate() throws JBIGenerationException {
        if (this.componentVersion == null) {
            throw new JBIGenerationException("Component version is null");
        }
        this.creator = CreatorFactory.getInstance().getCreator(this.componentVersion, this.getCreatorClassName());
        if (this.creator == null) {
            throw new JBIGenerationException("Can not find a valid creator in the classpath for component version " + this.componentVersion);
        }
        if (this.notNullInputFolder() && this.inputFolder == null) {
            throw new JBIGenerationException("Input folder is required and is null!");
        }
        if (this.notNullInputFolder() && !this.inputFolder.isDirectory()) {
            throw new JBIGenerationException("Input folder is required and seems to not be a folder...");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Input folder : " + this.inputFolder.getAbsolutePath()));
            var5_2 = files = this.inputFolder.listFiles();
            var4_3 = files.length;
            var3_5 = 0;
            while (var3_5 < var4_3) {
                file = var5_2[var3_5];
                this.logger.debug((Object)("  - File " + file.getAbsolutePath()));
                ++var3_5;
            }
        }
        if (this.outputFolder != null) {
            if (!this.outputFolder.exists()) {
                this.outputFolder.mkdirs();
            }
        } else {
            this.outputFolder = new File(".");
        }
        tmpDir = null;
        try {
            tmpDir = File.createTempFile("petalstmpdir", "txt").getParentFile();
        }
        catch (IOException e1) {
            throw new JBIGenerationException((Throwable)e1);
        }
        workDirectory = new File(tmpDir, "PETALS-JBIGEN4-" + this.creator.getComponentName() + "v" + this.creator.getComponentVersion() + "-at-" + System.currentTimeMillis());
        if (!workDirectory.exists()) {
            workDirectory.mkdirs();
        }
        if (!(saDirectory = new File(workDirectory, "sa")).exists()) {
            saDirectory.mkdirs();
        }
        this.logger.info((Object)("The JBI artefact file will be generated in " + this.outputFolder.getAbsolutePath()));
        this.saBean.setDescription(this.getSADescription());
        this.saBean.setSaName(this.getSAName());
        SUs = this.doGenerate();
        suZipFiles = new ArrayList<File>(SUs.size());
        for (SU su : SUs) {
            jbiXmlForSu = JbiXmlGenerator.getInstance().generateJbiXmlFileForSu(su.bean);
            suFileProvide = null;
            suName = this.getSUName(su);
            try {
                suFileProvide = JBIUtils.createSUZipFile(null, su.imports, suZipFiles, suName, jbiXmlForSu, workDirectory, this.outputFolder);
            }
            catch (GeneratorException e1) {
                throw new JBIGenerationException((Throwable)e1);
            }
            suBeanForSaP = new SuBeanForSa(su.bean);
            suBeanForSaP.setZipArtifact(suFileProvide.getName());
            suBeanForSaP.setSuName(suName);
            suBeanForSaP.setComponentName(this.creator.getComponentName());
            this.suBeans.add(suBeanForSaP);
        }
        this.saBean = new SaBean();
        this.saBean.setSus(this.suBeans);
        this.saBean.setSaName(this.getSAName());
        this.saBean.setDescription(this.getSADescription());
        jbiXmlForSa = JbiXmlGenerator.getInstance().generateJbiXmlFileForSa(this.saBean);
        jbiSa = new File(saDirectory, "jbi.xml");
        try {
            try {
                saZipFile = JBIUtils.createSAZipFile(suZipFiles, this.getSAName(), jbiXmlForSa, this.outputFolder, saDirectory);
            }
            catch (GeneratorException e) {
                throw new JBIGenerationException("Can not generate SA", (Throwable)e);
            }
        }
        finally {
            jbiSa.delete();
            ** for (suFile : suZipFiles)
        }
lbl-1000:
        // 1 sources

        {
            if (!suFile.exists()) continue;
            suFile.delete();
            continue;
        }
lbl80:
        // 1 sources

        return saZipFile;
    }

    protected void clean() {
    }

    protected abstract String getSUName(SU var1);

    protected abstract String getCreatorClassName();

    protected abstract String getSAName();

    protected abstract String getSADescription();

    protected abstract boolean notNullInputFolder();

    protected abstract List<SU> doGenerate() throws JBIGenerationException;

    public class SU {
        public SuBean bean;
        public List<File> imports;
    }
}

