/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.generator.commons;

import java.lang.reflect.Constructor;
import org.ow2.petals.tools.generator.commons.Creator;
import org.ow2.petals.tools.generator.commons.CreatorException;

public class CreatorFactory {
    private static CreatorFactory INSTANCE;

    public static final synchronized CreatorFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CreatorFactory();
        }
        return INSTANCE;
    }

    private CreatorFactory() {
    }

    public Creator getCreator(String version, String baseName) {
        Creator creator;
        block5: {
            creator = null;
            String finalVersion = version;
            if (finalVersion.indexOf(".") >= 0) {
                finalVersion = finalVersion.replaceAll("\\.", "");
            }
            finalVersion = finalVersion.trim();
            String className = String.valueOf(baseName) + finalVersion;
            try {
                creator = this.load(className);
            }
            catch (CreatorException e) {
                if (finalVersion.length() <= 1) break block5;
                String defaultClassName = String.valueOf(baseName) + finalVersion.charAt(0);
                try {
                    creator = this.load(defaultClassName);
                }
                catch (CreatorException creatorException) {
                    // empty catch block
                }
            }
        }
        return creator;
    }

    private Creator load(String className) throws CreatorException {
        Creator c = null;
        Class<?> managerClass = null;
        try {
            managerClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new CreatorException("Can not find creator class " + className, e);
        }
        Class<Creator> subclass = managerClass.asSubclass(Creator.class);
        try {
            Constructor<Creator> constructor = subclass.getConstructor(Creator.class);
            try {
                c = constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new CreatorException("Couldn't create creator of type " + className, e);
            }
        }
        catch (NoSuchMethodException e) {
            try {
                c = subclass.newInstance();
            }
            catch (Exception e1) {
                throw new CreatorException("Couldn't create creator of type " + className, e1);
            }
        }
        return c;
    }
}

