/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.generator.commons;

import com.ebmwebsourcing.commons.jbi.sugenerator.utils.JbiZipper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.ow2.petals.tools.generator.commons.GeneratorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBIUtils {
    public static File createSUZipFile(File wsdlFile, List<File> otherFiles, List<File> suZipFiles, String suName, String jbiXml, File outputDir, File workDirectory) throws GeneratorException {
        File suFile = null;
        File jbiSu = null;
        try {
            File tempSuDirectory = new File(workDirectory, suName);
            if (!tempSuDirectory.exists()) {
                tempSuDirectory.mkdirs();
            }
            if (!(jbiSu = new File(tempSuDirectory, "jbi.xml")).exists()) {
                jbiSu.createNewFile();
            }
            FileWriter writer = new FileWriter(jbiSu);
            writer.write(jbiXml);
            writer.close();
            JbiZipper jbiZipper = JbiZipper.getInstance();
            ArrayList<File> rootFiles = new ArrayList<File>();
            rootFiles.add(jbiSu);
            if (wsdlFile != null) {
                rootFiles.add(wsdlFile);
            }
            if (otherFiles != null) {
                rootFiles.addAll(otherFiles);
            }
            suFile = new File(outputDir, String.valueOf(suName) + ".zip");
            suZipFiles.add(jbiZipper.createSuZipFile(suFile, rootFiles));
            jbiSu.delete();
        }
        catch (Exception e) {
            throw new GeneratorException(e);
        }
        return suFile;
    }

    public static final File createSAZipFile(List<File> suZipFiles, String saName, String jbiXml, File outputDir, File workDirectory) throws GeneratorException {
        File saZipFile = null;
        String saFileName = saName;
        if (saFileName == null) {
            saFileName = "SA";
        }
        try {
            File jbiSA;
            File tempSADirectory = new File(workDirectory, saFileName);
            if (!tempSADirectory.exists()) {
                tempSADirectory.mkdirs();
            }
            if (!(jbiSA = new File(tempSADirectory, "jbi.xml")).exists()) {
                jbiSA.createNewFile();
            }
            File jbiSa = new File(tempSADirectory, "jbi.xml");
            byte[] utf8 = jbiXml.getBytes("UTF-8");
            FileWriter writer = new FileWriter(jbiSa);
            writer.write(new String(utf8));
            writer.close();
            JbiZipper jbiZipper = JbiZipper.getInstance();
            File saFile = new File(outputDir, String.valueOf(saFileName) + ".zip");
            saZipFile = jbiZipper.createSaZipFile(saFile, suZipFiles, jbiSa);
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
        return saZipFile;
    }
}

