/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.generator.jbi2rest;

import com.ebmwebsourcing.commons.jbi.sugenerator.beans.SaBean;
import com.ebmwebsourcing.commons.jbi.sugenerator.beans.SuBean;
import com.ebmwebsourcing.commons.jbi.sugenerator.beans.SuBeanForSa;
import com.ebmwebsourcing.commons.jbi.sugenerator.utils.JbiXmlGenerator;
import com.ebmwebsourcing.commons.jbi.sugenerator.utils.JbiZipper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.tools.generator.commons.Constants;
import org.ow2.petals.tools.generator.commons.Creator;
import org.ow2.petals.tools.generator.commons.CreatorFactory;
import org.ow2.petals.tools.generator.commons.GeneratorException;
import org.ow2.petals.tools.generator.commons.JBIUtils;
import org.ow2.petals.tools.generator.jbi.api.JBIGenerationEngine;
import org.ow2.petals.tools.generator.jbi.api.JBIGenerationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jbi2REST
implements JBIGenerationEngine {
    private static final String CREATOR_CLASS_NAME = "org.ow2.petals.tools.generator.jbi.restcommons.Creator";
    private static final String SA_PREFIX = "sa-jbi2rest-";
    private final Map<String, String> extensions;
    private final SaBean saBean;
    private final List<SuBeanForSa> suBeans;
    private File outputDir;
    private final String endpoint;
    private final QName service;
    private final QName itf;
    private final Log logger = LogFactory.getLog(Jbi2REST.class);

    public Jbi2REST(String endpoint, QName service, QName itf, Map<String, String> extensions) {
        this.endpoint = endpoint;
        this.service = service;
        this.itf = itf;
        this.extensions = extensions;
        this.saBean = new SaBean();
        this.suBeans = new ArrayList<SuBeanForSa>();
    }

    public File generate() throws JBIGenerationException {
        File saDirectory;
        this.logger.info((Object)("Trying generate JBI REST artefact for endpoint " + this.endpoint + " / " + this.service + " / " + this.itf));
        String componentVersion = this.extensions.get("component.version");
        if (componentVersion == null) {
            throw new JBIGenerationException("Component version is null");
        }
        Creator c = CreatorFactory.getInstance().getCreator(componentVersion, CREATOR_CLASS_NAME);
        if (c == null) {
            throw new JBIGenerationException("Can not find a valid creator in the classpath for component version " + componentVersion);
        }
        if (this.extensions != null && this.extensions.get(Constants.OUTPUT_DIR) != null) {
            this.outputDir = new File(this.extensions.get(Constants.OUTPUT_DIR));
            if (!this.outputDir.exists()) {
                this.outputDir.mkdirs();
            }
        }
        if (this.outputDir == null) {
            this.outputDir = new File(".");
        }
        this.logger.info((Object)("The JBI artefact file will be generated in " + this.outputDir.getAbsolutePath()));
        File tmpDir = null;
        try {
            tmpDir = File.createTempFile("petalstmpdir", "txt").getParentFile();
        }
        catch (IOException e1) {
            throw new JBIGenerationException((Throwable)e1);
        }
        File workDirectory = new File(tmpDir, "PETALS-JBI2REST-" + System.currentTimeMillis());
        if (!workDirectory.exists()) {
            workDirectory.mkdirs();
        }
        if (!(saDirectory = new File(workDirectory, "sa")).exists()) {
            saDirectory.mkdirs();
        }
        String saName = SA_PREFIX + System.currentTimeMillis();
        if (this.extensions != null && this.extensions.get(Constants.SA_NAME) != null) {
            saName = SA_PREFIX + this.extensions.get(Constants.SA_NAME);
        }
        this.saBean.setSaName(saName);
        this.saBean.setDescription("REST SA generated for the endpoint " + this.endpoint);
        ArrayList suZipFiles = new ArrayList();
        QName serviceName = this.service;
        String suConsumerName = "su-consumer-" + this.endpoint + "-JBI2REST";
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Generating provider for service " + serviceName));
        }
        String itfName = null;
        String itfNS = null;
        if (this.itf != null) {
            itfName = this.itf.getLocalPart();
            itfNS = this.itf.getNamespaceURI();
        }
        String srvName = null;
        String srvNS = null;
        if (this.service != null) {
            srvName = this.service.getLocalPart();
            srvNS = this.service.getNamespaceURI();
        }
        HashMap<String, String> elements = new HashMap<String, String>();
        String restServiceName = this.extensions.get("rest.endpointaddress") != null ? String.valueOf(this.extensions.get("rest.endpointaddress").toString()) + "Service" : String.valueOf(this.endpoint) + "Service";
        elements.put("rest.endpointaddress", restServiceName);
        elements.put("interface", itfName);
        elements.put("interfacens", itfNS);
        elements.put("service", srvName);
        elements.put("servicens", srvNS);
        elements.put("endpoint", this.endpoint);
        elements.put("component.version", componentVersion);
        elements.put("linktype", "");
        elements.put("sutype", "");
        elements.put("cdk.timeout", "60000");
        SuBean suProvide = c.createSUConsume(elements);
        String jbiXmlForSuProvide = JbiXmlGenerator.getInstance().generateJbiXmlFileForSu(suProvide);
        File suFileProvide = null;
        try {
            suFileProvide = JBIUtils.createSUZipFile(null, null, suZipFiles, (String)suConsumerName, (String)jbiXmlForSuProvide, (File)workDirectory, (File)this.outputDir);
        }
        catch (GeneratorException e1) {
            throw new JBIGenerationException((Throwable)e1);
        }
        SuBeanForSa suBeanForSaP = new SuBeanForSa(suProvide);
        suBeanForSaP.setZipArtifact(suFileProvide.getName());
        suBeanForSaP.setSuName(suConsumerName);
        suBeanForSaP.setComponentName(c.getComponentName());
        this.suBeans.add(suBeanForSaP);
        this.saBean.setSus(this.suBeans);
        String jbiXmlForSa = JbiXmlGenerator.getInstance().generateJbiXmlFileForSa(this.saBean);
        File jbiSa = new File(saDirectory, "jbi.xml");
        File saZipFile = null;
        try {
            byte[] utf8 = jbiXmlForSa.getBytes("UTF-8");
            FileWriter writer = new FileWriter(jbiSa);
            writer.write(new String(utf8));
            writer.close();
            JbiZipper jbiZipper = JbiZipper.getInstance();
            File saFile = new File(this.outputDir, String.valueOf(saName) + ".zip");
            saZipFile = jbiZipper.createSaZipFile(saFile, suZipFiles, jbiSa);
        }
        catch (IOException e) {
            throw new JBIGenerationException((Throwable)e);
        }
        jbiSa.delete();
        for (File suFile : suZipFiles) {
            if (!suFile.exists()) continue;
            suFile.delete();
        }
        return saZipFile;
    }
}

