/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.tools.generator.poller2jbi;

import com.ebmwebsourcing.commons.jbi.sugenerator.beans.SaBean;
import com.ebmwebsourcing.commons.jbi.sugenerator.beans.SuBean;
import com.ebmwebsourcing.commons.jbi.sugenerator.beans.SuBeanForSa;
import com.ebmwebsourcing.commons.jbi.sugenerator.utils.JbiXmlGenerator;
import com.ebmwebsourcing.commons.jbi.sugenerator.utils.JbiZipper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.tools.generator.commons.Constants;
import org.ow2.petals.tools.generator.commons.Creator;
import org.ow2.petals.tools.generator.commons.CreatorFactory;
import org.ow2.petals.tools.generator.jbi.api.JBIGenerationEngine;
import org.ow2.petals.tools.generator.jbi.api.JBIGenerationException;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Poller2Jbi
implements JBIGenerationEngine {
    private static final String CREATOR_CLASS_NAME = "org.petalslink.dsb.tools.generator.poller2jbi.Creator";
    private static final String SA_PREFIX = "SA-SERVICE_POLLER";
    private final Log logger = LogFactory.getLog(Poller2Jbi.class);
    private File outputDir;
    private String endpointName;
    private QName interfaceName;
    private QName serviceName;
    private Document inputDocument;
    private String responseEndpointName;
    private QName responseInterfaceName;
    private QName responseServiceName;
    private String cronExpression;
    private SaBean saBean;
    private ArrayList<SuBeanForSa> suBeans;
    private Map<String, String> extensions;
    private QName operation;
    private QName responseOperation;

    public Poller2Jbi(String endpointName, QName interfaceName, QName serviceName, QName operation, Document inputDocument, String responseEndpointName, QName responseInterfaceName, QName responseServiceName, QName responseOperation, String cronExpression, Map<String, String> extensions) {
        this.endpointName = endpointName;
        this.interfaceName = interfaceName;
        this.serviceName = serviceName;
        this.inputDocument = inputDocument;
        this.responseEndpointName = responseEndpointName;
        this.responseInterfaceName = responseInterfaceName;
        this.responseServiceName = responseServiceName;
        this.extensions = extensions;
        this.cronExpression = cronExpression;
        this.responseOperation = responseOperation;
        this.operation = operation;
        this.saBean = new SaBean();
        this.suBeans = new ArrayList();
    }

    public File generate() throws JBIGenerationException {
        String componentVersion = this.extensions.get("component.version");
        if (componentVersion == null) {
            throw new JBIGenerationException("Component version is null");
        }
        Creator c = CreatorFactory.getInstance().getCreator(componentVersion, CREATOR_CLASS_NAME);
        if (c == null) {
            throw new JBIGenerationException("Can not find a valid creator in the classpath for component version " + componentVersion);
        }
        if (this.extensions != null && this.extensions.get(Constants.OUTPUT_DIR) != null) {
            this.outputDir = new File(this.extensions.get(Constants.OUTPUT_DIR));
        }
        if (this.outputDir == null) {
            this.outputDir = new File(".");
        }
        this.logger.info((Object)("The JBI artefact file will be generated in " + this.outputDir.getAbsolutePath()));
        File tmpDir = null;
        try {
            tmpDir = File.createTempFile("petalstmpdir", "txt").getParentFile();
        }
        catch (IOException e1) {
            throw new JBIGenerationException((Throwable)e1);
        }
        File workDirectory = new File(tmpDir, "PETALS-REST2JBI-" + System.currentTimeMillis());
        if (!workDirectory.exists()) {
            workDirectory.mkdirs();
        }
        File inputFile = new File(workDirectory, "payload.xml");
        DOMSource source = new DOMSource(this.inputDocument);
        StreamResult result = new StreamResult(inputFile);
        try {
            TransformerFactory.newInstance().newTransformer().transform(source, result);
        }
        catch (Exception e1) {
            // empty catch block
        }
        File saDirectory = new File(workDirectory, "sa");
        if (!saDirectory.exists()) {
            saDirectory.mkdirs();
        }
        String saName = SA_PREFIX + System.currentTimeMillis();
        if (this.extensions != null && this.extensions.get(Constants.SA_NAME) != null) {
            saName = SA_PREFIX + this.extensions.get(Constants.SA_NAME);
        }
        this.saBean.setSaName(saName);
        this.saBean.setDescription("SA generated for the Service Poller");
        ArrayList<File> suZipFiles = new ArrayList<File>();
        String suName = "su-servicepoller-" + this.endpointName + "-Poller2JBI";
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("interface", this.interfaceName.getLocalPart());
        options.put("interfacens", this.interfaceName.getNamespaceURI());
        options.put("service", this.serviceName.getLocalPart());
        options.put("servicens", this.serviceName.getNamespaceURI());
        options.put("endpoint", this.endpointName);
        options.put("component.version", componentVersion);
        options.put("linktype", "");
        options.put("sutype", "");
        options.put("cdk.timeout", "60000");
        options.put("cdk.wsdlfile", null);
        options.put("cdk.operation", this.operation.getLocalPart());
        if (this.responseEndpointName != null) {
            options.put("response-endpoint", this.responseEndpointName);
        }
        if (this.responseInterfaceName != null) {
            options.put("response-interface", this.responseInterfaceName.getLocalPart());
        }
        if (this.responseServiceName != null) {
            options.put("response-service", this.responseServiceName.getLocalPart());
        }
        if (this.responseOperation != null) {
            options.put("response-operation", this.responseOperation.getLocalPart());
        }
        options.put("cron-expression", this.cronExpression);
        options.put("input-file", inputFile.getName());
        SuBean suProvide = c.createSUConsume(options);
        String jbiXmlForSu = JbiXmlGenerator.getInstance().generateJbiXmlFileForSu(suProvide);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Generated JBI :");
            this.logger.info((Object)jbiXmlForSu);
        }
        File suFile = null;
        File jbiSu = null;
        try {
            File tempSuDirectory = new File(workDirectory, suName);
            if (!tempSuDirectory.exists()) {
                tempSuDirectory.mkdirs();
            }
            if (!(jbiSu = new File(tempSuDirectory, "jbi.xml")).exists()) {
                jbiSu.createNewFile();
            }
            FileWriter writer = new FileWriter(jbiSu);
            writer.write(jbiXmlForSu);
            writer.close();
            JbiZipper jbiZipper = JbiZipper.getInstance();
            ArrayList<File> rootFiles = new ArrayList<File>();
            rootFiles.add(jbiSu);
            rootFiles.add(inputFile);
            suFile = new File(this.outputDir, suName + ".zip");
            suZipFiles.add(jbiZipper.createSuZipFile(suFile, rootFiles));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
            throw new JBIGenerationException((Throwable)e);
        }
        SuBeanForSa suBeanForSa = new SuBeanForSa(suProvide);
        suBeanForSa.setZipArtifact(suFile.getName());
        suBeanForSa.setSuName(suName);
        suBeanForSa.setComponentName(c.getComponentName());
        this.suBeans.add(suBeanForSa);
        jbiSu.delete();
        this.saBean.setSus(this.suBeans);
        String jbiXmlForSa = JbiXmlGenerator.getInstance().generateJbiXmlFileForSa(this.saBean);
        File jbiSa = new File(saDirectory, "jbi.xml");
        File saZipFile = null;
        try {
            byte[] utf8 = jbiXmlForSa.getBytes("UTF-8");
            FileWriter writer = new FileWriter(jbiSa);
            writer.write(new String(utf8));
            writer.close();
            JbiZipper jbiZipper = JbiZipper.getInstance();
            File saFile = new File(this.outputDir, saName + ".zip");
            saZipFile = jbiZipper.createSaZipFile(saFile, suZipFiles, jbiSa);
        }
        catch (IOException e) {
            throw new JBIGenerationException((Throwable)e);
        }
        jbiSa.delete();
        for (File su : suZipFiles) {
            if (!su.exists()) continue;
            su.delete();
        }
        return saZipFile;
    }
}

