/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.sample.wsn;

import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.INotificationConsumer;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.chamerling.javagrowl.Growl;
import org.chamerling.javagrowl.GrowlNetwork;
import org.petalslink.dsb.notification.client.http.simple.HTTPProducerClient;
import org.petalslink.dsb.notification.commons.NotificationException;
import org.petalslink.dsb.notification.service.NotificationConsumerService;
import org.petalslink.dsb.soap.CXFExposer;
import org.petalslink.dsb.soap.api.Service;
import org.w3c.dom.Document;

public class Growler {
    public static void main(String[] args) {
        final AtomicLong calls = new AtomicLong(0L);
        System.out.println("****** GROWL STUFF ******");
        GrowlNetwork growl = GrowlNetwork.register((String)"WSNReceiver", (String)"fil2fer");
        System.out.println("****** CREATING LOCAL SERVER ******");
        String address = "http://localhost:8878/petals/services/NotificationConsumerPortService";
        String dsbSubscribe = "http://localhost:8084/petals/services/NotificationConsumerPortService";
        String dsbNotify = "http://localhost:8084/petals/services/NotificationProducerPortService";
        System.out.println("Creating service which will receive notification messages from the DSB...");
        org.petalslink.dsb.commons.service.api.Service server = null;
        QName interfaceName = new QName("http://docs.oasis-open.org/wsn/bw-2", "NotificationConsumer");
        QName serviceName = new QName("http://docs.oasis-open.org/wsn/bw-2", "NotificationConsumerService");
        QName endpointName = new QName("http://docs.oasis-open.org/wsn/bw-2", "NotificationConsumerPort");
        INotificationConsumer consumer = new INotificationConsumer((Growl)growl){
            private final /* synthetic */ Growl val$growl;
            {
                this.val$growl = growl;
            }

            public void notify(Notify notify) throws WsnbException {
                System.out.println(String.format("Got a notify on HTTP service #%s, this notification comes from the DSB itself...", calls.incrementAndGet()));
                Document dom = Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify);
                System.out.println("==============================");
                try {
                    XMLHelper.writeDocument((Document)dom, (OutputStream)System.out);
                }
                catch (TransformerException transformerException) {
                    // empty catch block
                }
                System.out.println("==============================");
                this.val$growl.notify("WSNReceiver", "WSN Message", "Notify received!", "fil2fer");
            }
        };
        NotificationConsumerService service = new NotificationConsumerService(interfaceName, serviceName, endpointName, "NotificationConsumerService.wsdl", address, consumer);
        CXFExposer exposer = new CXFExposer();
        try {
            server = exposer.expose((Service)service);
            server.start();
            System.out.println("Local server is started and is ready to receive notifications");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("****** SUBSCRIBE TO NOTIFICATION ******");
        QName topic = new QName("http://www.petalslink.org/dsb/topicsns/", "DSBTopic", "dsb");
        HTTPProducerClient pc = new HTTPProducerClient(dsbSubscribe);
        try {
            pc.subscribe(topic, address);
        }
        catch (NotificationException e1) {
            e1.printStackTrace();
        }
        try {
            System.out.println("Waiting 1 hour, now you can test...");
            TimeUnit.HOURS.sleep(1L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("Bye!");
    }
}

