/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.sample.wsn;

import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.GetResourcePropertyResponse;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.WstopConstants;
import com.ebmwebsourcing.wsstar.wsnb.services.INotificationConsumer;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.ebmwebsourcing.wsstar.wsrfbf.services.faults.AbsWSStarFault;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import org.petalslink.dsb.notification.client.http.HTTPNotificationConsumerClient;
import org.petalslink.dsb.notification.client.http.HTTPNotificationProducerClient;
import org.petalslink.dsb.notification.client.http.HTTPNotificationProducerRPClient;
import org.petalslink.dsb.notification.service.NotificationConsumerService;
import org.petalslink.dsb.soap.CXFExposer;
import org.petalslink.dsb.soap.api.Service;
import org.w3c.dom.Document;

public class Main {
    public static void main(String[] args) {
        System.out.println("****** CREATING LOCAL SERVER ******");
        String address = "http://localhost:8878/petals/services/NotificationConsumerPortService";
        String dsbSubscribe = "http://localhost:8084/petals/services/NotificationConsumerPortService";
        String dsbNotify = "http://localhost:8084/petals/services/NotificationProducerPortService";
        System.out.println("Creating service which will receive notification messages from the DSB...");
        org.petalslink.dsb.commons.service.api.Service server = null;
        QName interfaceName = new QName("http://docs.oasis-open.org/wsn/bw-2", "NotificationConsumer");
        QName serviceName = new QName("http://docs.oasis-open.org/wsn/bw-2", "NotificationConsumerService");
        QName endpointName = new QName("http://docs.oasis-open.org/wsn/bw-2", "NotificationConsumerPort");
        INotificationConsumer consumer = new INotificationConsumer(){

            public void notify(Notify notify) throws WsnbException {
                System.out.println("Got a notify on HTTP service, this notification comes from the DSB itself...");
                Document dom = Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify);
                System.out.println("==============================");
                try {
                    XMLHelper.writeDocument((Document)dom, (OutputStream)System.out);
                }
                catch (TransformerException transformerException) {
                    // empty catch block
                }
                System.out.println("==============================");
            }
        };
        NotificationConsumerService service = new NotificationConsumerService(interfaceName, serviceName, endpointName, "NotificationConsumerService.wsdl", address, consumer);
        CXFExposer exposer = new CXFExposer();
        try {
            server = exposer.expose((Service)service);
            server.start();
            System.out.println("Local server is started and is ready to receive notifications");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("****** SUBSCRIBE TO NOTIFICATION ******");
        System.out.println("Subscribing to receive DSB notifications...");
        HTTPNotificationProducerClient producerClient = new HTTPNotificationProducerClient(dsbSubscribe);
        Subscribe subscribe = Main.loadSubscribe();
        try {
            SubscribeResponse response = producerClient.subscribe(subscribe);
            System.out.println("Got a response from the DSB");
            Document dom = Wsnb4ServUtils.getWsnbWriter().writeSubscribeResponseAsDOM(response);
            XMLHelper.writeDocument((Document)dom, (OutputStream)System.out);
        }
        catch (WsnbException e) {
            e.printStackTrace();
        }
        catch (AbsWSStarFault e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        System.out.println("****** SEND NOTIFICATION TO THE DSB ******");
        System.out.println("Sending a notification to the DSB...");
        HTTPNotificationConsumerClient consumerClient = new HTTPNotificationConsumerClient(dsbNotify);
        Notify notify = Main.loadNotify();
        int i22 = 0;
        while (i22 < 10) {
            try {
                consumerClient.notify(notify);
            }
            catch (WsnbException e) {
                e.printStackTrace();
            }
            ++i22;
        }
        try {
            System.out.println("Waiting...");
            TimeUnit.SECONDS.sleep(10L);
        }
        catch (InterruptedException i22) {
            // empty catch block
        }
        System.out.println("****** GET RESOURCE PROPERTIES ******");
        HTTPNotificationProducerRPClient resourceClient = new HTTPNotificationProducerRPClient(dsbSubscribe);
        try {
            QName qname = WstopConstants.TOPIC_SET_QNAME;
            GetResourcePropertyResponse response = resourceClient.getResourceProperty(qname);
            System.out.println("Get Resource response :");
            Document dom = Wsnb4ServUtils.getWsrfrpWriter().writeGetResourcePropertyResponseAsDOM(response);
            XMLHelper.writeDocument((Document)dom, (OutputStream)System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("-Bye");
    }

    private static Notify loadNotify() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            Document document = factory.newDocumentBuilder().parse(Main.class.getResourceAsStream("/notify.xml"));
            return Wsnb4ServUtils.getWsnbReader().readNotify(document);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Subscribe loadSubscribe() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            Document document = factory.newDocumentBuilder().parse(Main.class.getResourceAsStream("/subscribe.xml"));
            return Wsnb4ServUtils.getWsnbReader().readSubscribe(document);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

