/**
 * Synapse - Enterprise Collaborative Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * CheckInterceptor.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.aop;

import org.aopalliance.intercept.MethodInvocation;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/**
 * @author mcarpentier
 * 
 * Trace the annotation method process duration
 * 
 */
public class BasicMethodTraceInterceptor extends AdvisorInterceptor {

    private static final long serialVersionUID = 209489587176210355L;

    private static final Logger log = Logger.getLogger(BasicMethodTraceInterceptor.class);

    @Override
    public Object invoke(final MethodInvocation method) throws Throwable {
        try {
            if (log.isEnabledFor(Level.INFO)) {
                log.info("[AOP] [" + method.getMethod().getDeclaringClass() + "] Entering method '"
                        + method.getMethod().getName() + "()'");
            }
            return method.proceed();
        } finally {
            if (log.isEnabledFor(Level.INFO)) {
                log.info("[AOP] [" + method.getMethod().getDeclaringClass() + "] Exiting method '"
                        + method.getMethod().getName() + "()'");
            }
        }
    }
}
