/**
 * Synapse - Enterprise Collaborative Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.aop.exception;

import java.io.Serializable;

/**
 * @author mcarpentier
 * 
 * Used when an argument is null whereas it shouldn't be
 *
 */
public class NullArgumentException extends Exception implements Serializable {

    private static final long serialVersionUID = 9099796182518415571L;

    public NullArgumentException() {
        super();
    }

    public NullArgumentException(final Exception e) {
        super(e);
    }

    public NullArgumentException(final String message) {
        super(message);
    }

}
