/******************************************************************************
 * Copyright (c) 2008, EBM WebSourcing
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     EBM WebSourcing - initial API and implementation
 *******************************************************************************/

package com.ebmwebsourcing.commons.jbi.sugenerator.beans;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

/**
 * A bean used to generate jbi.xml files for a Service Assembly.
 * @author Vincent Zurczak - EBM WebSourcing
 */
public class SaBean {
	/** The service assembly name. */
	protected String saName;
	/** The service assembly description. */
	protected String description;
	/** A list of SuBeanForSa with the required data about the service units contained into this service assembly. */
	protected Collection<SuBeanForSa> sus = Collections.emptyList();
	
	
	/**
	 * @return the saName
	 */
	public String getSaName() {
		return saName;
	}
	/**
	 * @param saName the saName to set
	 */
	public void setSaName( String saName ) {
		this.saName = saName;
	}
	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}
	/**
	 * @param description the description to set
	 */
	public void setDescription( String description ) {
		this.description = description;
	}
	/**
	 * @return the sus
	 */
	public Collection<SuBeanForSa> getSus() {
		return Collections.unmodifiableCollection( sus );
	}
	/**
	 * @param sus the sus to set
	 */
	public void setSus( List<SuBeanForSa> sus ) {
		this.sus = sus;
	}
}
