/******************************************************************************
 * Copyright (c) 2008, EBM WebSourcing
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     EBM WebSourcing - initial API and implementation
 *******************************************************************************/

package com.ebmwebsourcing.commons.jbi.sugenerator.beans;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * A bean used to generate jbi.xml files for a Service Unit.
 * @author Vincent Zurczak - EBM WebSourcing
 */
public class SuBean {
	/** The list of name spaces of the document, each one being given as a couple <code>( prefix, URL )</code>. */
	public Map<String, String> namespaces = new HashMap<String, String> ();
	
	/** The service name. */
	protected String serviceName;
	/** The service name name space. */
	protected String serviceNameNsUrl;
	
	/** The interface name. */
	protected String interfaceName;
	/** The interface name name space. */
	protected String interfaceNameNsUrl;
	
	/** The end point name. */
	protected String endpointName;
	
	/** The link type. */
	protected String linkType;
	/** True if the service unit is in consume mode. False by default. */
	protected boolean isConsume = false;
	/** True if the service unit is used to configure a binding component. True by default.  */
	protected boolean isBc = true;
	
	/** The component name which will <i>use</i> this service unit. */
	protected String suForComponentName;
	/** The version of the component which will <i>use</i> this service unit. */
	protected String suForComponentVersion;
	/** A human-readable explanation of what this service unit configures (e.g. FTP, XSLT). */
	protected String suType;
	
	/** An ordered list of XML elements relative to the CDK schema. */
	final public ArrayList<XmlElement> cdkElements = new ArrayList<XmlElement> ();
	/** An ordered list of XML elements relative to a component schema version. */
	final public ArrayList<XmlElement> specificElements = new ArrayList<XmlElement> ();
	
	/**
	 * The mapping between an URL and a list of XmlElements.
	 * 
	 * If the files associated with this URL have been renamed during the import, and
	 * that this URL is associated with these XmlElements, then their value 
	 * is updated with the new file name. This update is taken into account during the generation
	 * of the jbi.xml for the service unit.
	 */
	final public Map<URL, List<XmlElement>> urlsToElements = new HashMap<URL, List<XmlElement>> ();
	/**
	 * The mapping between an URL and a list of XmlAttributes.
	 * 
	 * If the files associated with this URL have been renamed during the import, and
	 * that this URL is associated with these XmlAttributes, then their value 
	 * is updated with the new file name. This update is taken into account during the generation
	 * of the jbi.xml for the service unit.
	 */
	final public Map<URL, List<XmlAttribute>> urlsToAttributes = new HashMap<URL, List<XmlAttribute>> ();
	

	/**
	 * @return the serviceName
	 */
	public String getServiceName() {
		return serviceName;
	}
	/**
	 * @param serviceName the serviceName to set
	 */
	public void setServiceName( String serviceName ) {
		this.serviceName = serviceName;
	}
	/**
	 * @return the serviceNameNs
	 */
	public String getServiceNameNsUrl() {
		return serviceNameNsUrl;
	}
	/**
	 * @param serviceNameNs the serviceNameNs to set
	 */
	public void setServiceNameNsUrl( String serviceNameNs ) {
		this.serviceNameNsUrl = serviceNameNs;
	}
	/**
	 * @return the interfaceName
	 */
	public String getInterfaceName() {
		return interfaceName;
	}
	/**
	 * @param interfaceName the interfaceName to set
	 */
	public void setInterfaceName( String interfaceName ) {
		this.interfaceName = interfaceName;
	}
	/**
	 * @return the interfaceNameNs
	 */
	public String getInterfaceNameNsUrl() {
		return interfaceNameNsUrl;
	}
	/**
	 * @param interfaceNameNs the interfaceNameNs to set
	 */
	public void setInterfaceNameNsUrl( String interfaceNameNs ) {
		this.interfaceNameNsUrl = interfaceNameNs;
	}
	/**
	 * @return the endpointName
	 */
	public String getEndpointName() {
		return endpointName;
	}
	/**
	 * @param endpointName the endpointName to set
	 */
	public void setEndpointName( String endpointName ) {
		this.endpointName = endpointName;
	}
	/**
	 * @return the isConsume
	 */
	public boolean isConsume() {
		return isConsume;
	}
	/**
	 * @param isConsume the isConsume to set. False by default.
	 */
	public void setConsume( boolean isConsume ) {
		this.isConsume = isConsume;
	}
	/**
	 * @return the isBc
	 */
	public boolean isBc() {
		return isBc;
	}
	/**
	 * @param isBc the isBc to set. True by default.
	 */
	public void setBc(boolean isBc) {
		this.isBc = isBc;
	}
	/**
	 * @return the linkType
	 */
	public String getLinkType() {
		return linkType;
	}
	/**
	 * @param linkType the linkType to set
	 */
	public void setLinkType( String linkType ) {
		this.linkType = linkType;
	}
	/**
	 * @return the suForComponentName
	 */
	public String getSuForComponentName() {
		return suForComponentName;
	}
	/**
	 * @param suForComponentName the suForComponentName to set
	 */
	public void setSuForComponentName( String suForComponentName ) {
		this.suForComponentName = suForComponentName;
	}
	/**
	 * @return the suForComponentVersion
	 */
	public String getSuForComponentVersion() {
		return suForComponentVersion;
	}
	/**
	 * @param suForComponentVersion the suForComponentVersion to set
	 */
	public void setSuForComponentVersion( String suForComponentVersion ) {
		this.suForComponentVersion = suForComponentVersion;
	}
	/**
	 * @return the suType
	 */
	public String getSuType() {
		return suType;
	}
	/**
	 * @param suType the suType to set
	 */
	public void setSuType(String suType) {
		this.suType = suType;
	}

	/**
	 * @return the CDK XML elements as a String.
	 */
	public String getCdkElementsAsString() {
		String result = "";
		for( XmlElement cdkElement : cdkElements )
			result += cdkElement.toString( 3 );
		
		if( result.endsWith( "\n" ))
			result = result.substring( 0, result.length() - 1 );
		return result;
	}
	
	/**
	 * @return the component specific elements as a String.
	 */
	public String getSpecificsElementsAsString() {
		String result = "";
		for( XmlElement specificElement : specificElements )
			result += specificElement.toString( 3 );
		
		if( result.endsWith( "\n" ))
			result = result.substring( 0, result.length() - 1 );
		return result;
	}
}
