/******************************************************************************
 * Copyright (c) 2008, EBM WebSourcing
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     EBM WebSourcing - initial API and implementation
 *******************************************************************************/

package com.ebmwebsourcing.commons.jbi.sugenerator.beans;

import java.util.ArrayList;
import java.util.List;

/**
 * A bean used to store information about an XML attribute.
 * This class is strongly associated with {@link XmlElement}.
 * 
 * @author Vincent Zurczak - EBM WebSourcing
 */
public class XmlAttribute {
	/** The name of the attribute. */
	protected String name;
	/** The value of the attribute. */
	protected String value;
	/** Whether the attribute is optional or not. False by default. */
	protected boolean isOptional = false;;
	
	
	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name the name to set
	 */
	public void setName( String name ) {
		this.name = name;
	}
	/**
	 * @return the value
	 */
	public String getValue() {
		return value;
	}
	/**
	 * @param value the value to set
	 */
	public void setValue( String value ) {
		this.value = value;
	}
	/**
	 * @return the isOptional
	 */
	public boolean isOptional() {
		return isOptional;
	}
	/**
	 * @param isOptional the isOptional to set. False by default.
	 */
	public void setOptional( boolean isOptional ) {
		this.isOptional = isOptional;
	}
	
	/*
	 * (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		if( isOptional && ( value == null || "".equals( value )))
				return "";
		else
			return name + "=\"" + value + "\"";
	}
	
	/**
	 * Return a list of attributes having the same attribute name.
	 * Each XmlAttribute contained in the list has the following properties:
	 * <ul>
	 * <li>The name given in parameter.</li>
	 * <li>The optional property given in parameter.</li>
	 * <li>One of the value (contained in values) as its value.</li>
	 * </ul>
	 * 
	 * @param attributeName the attribute name.
	 * @param isOptional whether this attribute is optional or not.
	 * @param values a list of values for this attribute.
	 * @return a list of XmlAttributes.
	 */
	public static List<XmlAttribute> createListOfAttributes( String attributeName, boolean isOptional, List<String> values ) {
		List<XmlAttribute> attributes = new ArrayList<XmlAttribute> ();
		
		for( String value : values ) {
			XmlAttribute attribute = new XmlAttribute();
			attribute.setName( attributeName );
			attribute.setOptional( isOptional );
			attribute.setValue( value );
			attributes.add( attribute );
		}
		
		return attributes;
	}
}
