/******************************************************************************
 * Copyright (c) 2008, EBM WebSourcing
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     EBM WebSourcing - initial API and implementation
 *******************************************************************************/

package com.ebmwebsourcing.commons.jbi.sugenerator.utils;

import com.ebmwebsourcing.commons.jbi.sugenerator.beans.SaBean;
import com.ebmwebsourcing.commons.jbi.sugenerator.beans.SuBean;
import com.ebmwebsourcing.commons.jbi.sugenerator.generated.SaJbiXmlTemplate;
import com.ebmwebsourcing.commons.jbi.sugenerator.generated.SuJbiXmlTemplate;

/**
 * A facade class which calls a template and returns the generation result as a String.
 * @author Vincent Zurczak - EBM WebSourcing
 */
public class JbiXmlGenerator {
	/** The unique instance of this class. */
	private static JbiXmlGenerator instance = new JbiXmlGenerator();
	
	
	/** Private empty constructor (singleton pattern). */
	private JbiXmlGenerator() {}
	
	/**
	 * @return the unique instance of this class.
	 */
	public static JbiXmlGenerator getInstance() {
		return instance;
	}
	
	/**
	 * Generate the content of a service unit jbi.xml file.
	 * @param suBean a bean containing everything required for the generation.
	 * @return the result of the generation as a String.
	 */
	public String generateJbiXmlFileForSu( SuBean suBean ) {
		SuJbiXmlTemplate tpl = new SuJbiXmlTemplate();
		String result = tpl.generate( suBean );
		return result;
	}
	
	/**
	 * Generate the content of a service assembly jbi.xml file.
	 * @param saBean a bean containing everything required for the generation.
	 * @return the result of the generation as a String.
	 */
	public String generateJbiXmlFileForSa( SaBean saBean ) {
		SaJbiXmlTemplate tpl = new SaJbiXmlTemplate();
		String result = tpl.generate( saBean );
		return result;
	}
}
