/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.commons.jbi.sugenerator.beans;

import com.ebmwebsourcing.commons.jbi.sugenerator.beans.XmlAttribute;
import com.ebmwebsourcing.commons.jbi.sugenerator.utils.JbiNameFormatter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlElement {
    protected String name;
    protected String value;
    protected boolean isNillable = false;
    protected boolean isOptional = false;
    protected String defaultValue;
    public final List<XmlAttribute> attributes = new ArrayList<XmlAttribute>();
    public final List<XmlElement> childrenElements = new ArrayList<XmlElement>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isNillable() {
        return this.isNillable;
    }

    public void setNillable(boolean isNillable) {
        this.isNillable = isNillable;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public void setOptional(boolean isOptional) {
        this.isOptional = isOptional;
    }

    public String toString() {
        return this.toString(1);
    }

    public static String repeatString(String text, int repeat) {
        String result = "";
        for (int i = 0; i < repeat; ++i) {
            result = result + text;
        }
        return result;
    }

    public static List<XmlElement> createListOfElements(String name, boolean isOptional, boolean isNillable, List<String> values, List<XmlAttribute> attributes) {
        ArrayList<XmlElement> elements = new ArrayList<XmlElement>();
        for (String value : values) {
            XmlElement element = new XmlElement();
            element.setName(name);
            element.setOptional(isOptional);
            element.setNillable(isNillable);
            element.setValue(value);
            elements.add(element);
            if (attributes == null) continue;
            element.attributes.addAll(attributes);
        }
        return elements;
    }

    public static List<XmlElement> createListOfElements(String name, List<List<XmlElement>> childrenElements, boolean isOptional, boolean isNillable, List<XmlAttribute> attributes) {
        ArrayList<XmlElement> elements = new ArrayList<XmlElement>();
        for (List<XmlElement> children : childrenElements) {
            XmlElement element = new XmlElement();
            element.setName(name);
            element.setOptional(isOptional);
            element.setNillable(isNillable);
            elements.add(element);
            if (children != null) {
                element.childrenElements.addAll(children);
            }
            if (attributes == null) continue;
            element.attributes.addAll(attributes);
        }
        return elements;
    }

    public String toString(int indentationLevel) {
        boolean valueIsNull;
        String childrenResult = "";
        for (XmlElement childElement : this.childrenElements) {
            childrenResult = childrenResult + childElement.toString(indentationLevel + 1);
        }
        childrenResult = childrenResult.trim();
        boolean bl = valueIsNull = (this.value == null || "".equals(this.value)) && "".equals(childrenResult);
        if (valueIsNull && !this.isNillable) {
            return "";
        }
        if (this.isNillable && this.isOptional && valueIsNull) {
            return "";
        }
        if (this.isOptional && !this.isNillable && (this.value != null && this.value.equals(this.defaultValue) || this.value == null && this.defaultValue == null)) {
            return "";
        }
        String result = XmlElement.repeatString("\t", indentationLevel) + "<" + this.name;
        for (XmlAttribute attr : this.attributes) {
            result = result + " " + attr.toString();
        }
        if (this.isNillable && valueIsNull) {
            result = result + " xsi:nil=\"true\" />\n";
            return result;
        }
        if (!valueIsNull && "".equals(childrenResult)) {
            result = result + ">" + this.value + "</" + this.name + ">\n";
            return result;
        }
        result = result + ">\n";
        result = result + childrenResult;
        result = result + XmlElement.repeatString("\t", indentationLevel) + "</" + this.name + ">\n";
        return result;
    }

    public String toStringAsOldCdk(int indentationLevel) {
        boolean valueIsNull;
        String childrenResult = "";
        for (XmlElement childElement : this.childrenElements) {
            childrenResult = childrenResult + childElement.toStringAsOldCdk(indentationLevel + 1);
        }
        boolean bl = valueIsNull = (this.value == null || "".equals(this.value)) && "".equals(childrenResult);
        if (valueIsNull) {
            return "";
        }
        String result = XmlElement.repeatString("\t", indentationLevel) + "<extensions:param name=\"" + JbiNameFormatter.removeNamespaceElements(this.name) + "\"";
        for (XmlAttribute attr : this.attributes) {
            result = result + " " + attr.toString();
        }
        result = result + ">" + this.value + "</extensions:param>";
        return result;
    }
}

