/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.commons.jbi.sugenerator.utils;

import com.ebmwebsourcing.commons.jbi.sugenerator.utils.JbiNameFormatter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileImporter {
    private static FileImporter instance = new FileImporter();
    private static int renamedCpt = 0;

    private FileImporter() {
    }

    public static FileImporter getInstance() {
        return instance;
    }

    public String importFile(URL url, String fileRelativePath, File folder, boolean overwrite, boolean rename, boolean showHiddenFiles) throws FileImportsException, IllegalArgumentException {
        HashMap<URL, String> urlsAndRelativePath = new HashMap<URL, String>();
        fileRelativePath = fileRelativePath == null ? "" : fileRelativePath;
        urlsAndRelativePath.put(url, fileRelativePath);
        Map<URL, String> importedFiles = this.importFiles(urlsAndRelativePath, folder, overwrite, rename, showHiddenFiles);
        return importedFiles.get(url);
    }

    public Map<URL, String> importFiles(Map<URL, String> urlsAndRelativePath, File folder, boolean overwrite, boolean rename, boolean showHiddenFiles) throws FileImportsException, IllegalArgumentException {
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException(folder.getAbsolutePath() + " is not a directory.");
        }
        GregorianCalendar calendar = new GregorianCalendar();
        SimpleDateFormat sdf = new SimpleDateFormat("dd_MM_yyyy__'at'__HH_mm_ss");
        HashMap<URL, String> fileNames = new HashMap<URL, String>();
        FileImportsException finalException = new FileImportsException();
        URL lastUrl = null;
        for (Map.Entry<URL, String> importedUrl : urlsAndRelativePath.entrySet()) {
            boolean importFailed = false;
            try {
                int len;
                String folderPath;
                String fileName;
                lastUrl = importedUrl.getKey();
                String urlPath = importedUrl.getKey().toExternalForm();
                urlPath = urlPath.replaceAll("\\\\", "/");
                String[] parts = urlPath.split("/");
                String originalFileName = fileName = parts.length > 1 ? parts[parts.length - 1] : "";
                if (fileName.startsWith(".") && showHiddenFiles) {
                    fileName = fileName.substring(1);
                }
                if ("".equals(fileName)) {
                    fileName = "importedFile__" + sdf.format(calendar.getTime());
                }
                fileName = fileName.replaceAll("[^-._\\w]", "_");
                String relativePath = importedUrl.getValue();
                relativePath = relativePath == null ? "" : relativePath;
                relativePath = relativePath.replaceAll("\\\\", "/");
                relativePath = relativePath.endsWith(originalFileName) ? relativePath.substring(0, relativePath.length() - originalFileName.length()) : relativePath;
                File destinationFolder = new File(folder, relativePath = relativePath.endsWith("/") ? relativePath.substring(0, relativePath.length() - 1) : relativePath);
                String destinationFolderPath = destinationFolder.getAbsolutePath().toLowerCase();
                if (!destinationFolderPath.startsWith(folderPath = folder.getAbsolutePath().toLowerCase())) {
                    relativePath = "";
                }
                if (!"".equals(relativePath) && !(folder = new File(folder, relativePath)).exists()) {
                    folder.mkdirs();
                }
                InputStream source = importedUrl.getKey().openStream();
                File newFile = new File(folder, fileName);
                if (!newFile.exists()) {
                    newFile.createNewFile();
                } else if (overwrite) {
                    PrintWriter printwriter = new PrintWriter(new FileOutputStream(newFile));
                    printwriter.println("");
                    printwriter.close();
                } else if (rename) {
                    int dotPosition = fileName.lastIndexOf(".");
                    fileName = dotPosition <= 0 ? fileName + "_renamed_" + renamedCpt++ : JbiNameFormatter.insertSuffixBeforeFileExtension(fileName, "_renamed_" + renamedCpt++);
                    newFile = new File(folder, fileName);
                    newFile.createNewFile();
                } else {
                    importFailed = true;
                }
                relativePath = relativePath + ("".equals(relativePath) ? "" : "/");
                relativePath = relativePath + fileName;
                fileNames.put(importedUrl.getKey(), relativePath);
                if (importFailed) {
                    IOException e = new IOException("File " + fileName + " already exists. Import failed.");
                    finalException.failedImportUrls.put(lastUrl, e);
                    continue;
                }
                FileOutputStream out = new FileOutputStream(newFile);
                byte[] buf = new byte[1024];
                while ((len = source.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
                source.close();
            }
            catch (Exception e) {
                finalException.failedImportUrls.put(lastUrl, e);
            }
        }
        if (finalException.hasExceptions()) {
            throw finalException;
        }
        return fileNames;
    }

    public class FileImportsException
    extends Exception {
        private static final long serialVersionUID = 3562089833670361410L;
        public Map<URL, Exception> failedImportUrls = new HashMap<URL, Exception>();

        protected boolean hasExceptions() {
            return this.failedImportUrls.size() >= 1;
        }

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            PrintWriter result = new PrintWriter(stringWriter);
            result = this.failedImportUrls.isEmpty() ? result.append("FileImportsException: no error was found while importing files.\n") : (this.failedImportUrls.size() > 1 ? result.append("FileImportsException: " + this.failedImportUrls.size() + " errors were found while importing files.\n") : result.append("FileImportsException: 1 error was found while importing files.\n"));
            for (Map.Entry<URL, Exception> e : this.failedImportUrls.entrySet()) {
                result.print("URL " + e.getKey() + " failed to be imported.");
                result.print(e.getValue().getMessage());
                e.getValue().printStackTrace(result);
            }
            result.flush();
            return stringWriter.toString();
        }
    }
}

