/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.commons.jbi.sugenerator.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JbiNameFormatter {
    public static final String PETALS_AUTO_GENERATE_ENDPOINT = "petals:autogenerate";

    public static String createSuName(String suType, String serviceName, boolean isConsume) {
        String serviceNameRewritten = JbiNameFormatter.removeNamespaceElements(serviceName);
        String suMode = isConsume ? "consume" : "provide";
        return "su-" + suType + "-" + serviceNameRewritten + "-" + suMode;
    }

    public static String createSaName(String suType, String serviceName, boolean isConsume) {
        String serviceNameRewritten = JbiNameFormatter.removeNamespaceElements(serviceName);
        String suMode = isConsume ? "consume" : "provide";
        return "sa-" + suType + "-" + serviceNameRewritten + "-" + suMode;
    }

    public static String createSaName(String suName) {
        if (suName == null) {
            return "";
        }
        if (suName.startsWith("su-")) {
            return suName.replaceFirst("su-", "sa-");
        }
        return "sa-" + suName;
    }

    public static String removeNamespaceElements(String name) {
        String[] splits;
        if (name == null) {
            return "";
        }
        Pattern namespacePattern = Pattern.compile("\\{.+\\}");
        Matcher m = namespacePattern.matcher(name);
        if (name.contains("{") && !m.find()) {
            return "";
        }
        int namespaceEndPosition = name.lastIndexOf("}");
        if (namespaceEndPosition > 0) {
            name = name.substring(namespaceEndPosition + 1);
        }
        if ((splits = name.split(":")).length == 1) {
            return name.trim();
        }
        return splits[splits.length - 1].trim();
    }

    public static String extractNamespaceUri(String namespace) {
        if (namespace == null) {
            return "";
        }
        String namespaceCopy = namespace;
        Pattern namespacePattern = Pattern.compile("\\{.+\\}");
        Matcher m = namespacePattern.matcher(namespaceCopy);
        if (!m.find()) {
            return "";
        }
        if ((namespaceCopy = namespaceCopy.substring(m.start(), m.end())).startsWith("{")) {
            namespaceCopy = namespaceCopy.substring(1);
        }
        if (namespaceCopy.endsWith("}")) {
            namespaceCopy = namespaceCopy.substring(0, namespaceCopy.length() - 1);
        }
        return namespaceCopy.trim();
    }

    public static String removeFileExtension(String fileName) {
        if (fileName == null) {
            return "";
        }
        int index = fileName.lastIndexOf(46);
        if (index <= 0) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    public static String insertSuffixBeforeFileExtension(String fileName, String suffix) {
        if (fileName == null) {
            return suffix;
        }
        int index = fileName.lastIndexOf(46);
        if (index <= 0) {
            return fileName + suffix;
        }
        return fileName.substring(0, index) + suffix + fileName.substring(index);
    }

    public static String getNsPrefixFromNsDeclaration(String nsDeclaration) {
        NsDeclarationElements decl = JbiNameFormatter.extractNsDeclarationElements(nsDeclaration);
        return decl != null ? decl.getPrefix() : null;
    }

    public static String getNsUrlFromNsDeclaration(String nsDeclaration) {
        NsDeclarationElements decl = JbiNameFormatter.extractNsDeclarationElements(nsDeclaration);
        return decl != null ? decl.getUrl() : null;
    }

    private static NsDeclarationElements extractNsDeclarationElements(String nsDeclaration) {
        if (nsDeclaration == null) {
            return null;
        }
        Pattern nsDeclarationPattern = Pattern.compile("xmlns(\\:[-_\\w]+)?\\=\"[-.:/_\\w]+\"");
        Matcher m = nsDeclarationPattern.matcher(nsDeclaration);
        if (!m.find()) {
            return null;
        }
        NsDeclarationElements result = new NsDeclarationElements();
        String[] parts = nsDeclaration.split("=");
        result.url = parts[1].replace("\"", "");
        result.prefix = parts[0].replace("xmlns", "").replace(":", "");
        return result;
    }

    private static class NsDeclarationElements {
        private String prefix;
        private String url;

        private NsDeclarationElements() {
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

