/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.commons.jbi.sugenerator.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Zipper {
    private static Zipper instance = new Zipper();

    private Zipper() {
    }

    public static Zipper getInstance() {
        return instance;
    }

    public final File createZipFile(File zipFile, Map<String, File> filesToZip) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));
        for (Map.Entry<String, File> entry : filesToZip.entrySet()) {
            if (!entry.getValue().exists()) continue;
            this.addFileToZip(zos, entry.getValue(), entry.getKey());
        }
        GregorianCalendar calendar = new GregorianCalendar();
        SimpleDateFormat sdf = new SimpleDateFormat("MM dd, yyyy 'at' HH:mm:ss");
        String comment = "File generated on " + sdf.format(calendar.getTime());
        zos.setComment(comment);
        zos.close();
        return zipFile;
    }

    public final File createZipFile(String zipFilePath, Map<String, File> filesToZip) throws IOException {
        return this.createZipFile(new File(zipFilePath), filesToZip);
    }

    private final void addFileToZip(ZipOutputStream out, File file, String entry) {
        byte[] buf = new byte[1024];
        ZipEntry ze = new ZipEntry(entry);
        try {
            int len;
            out.putNextEntry(ze);
            FileInputStream in = new FileInputStream(file);
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            ((InputStream)in).close();
            out.closeEntry();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

