/**
 * easySchema - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.commons.schema.api;

import java.net.URI;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public interface Schema extends SchemaElement {


	/*
	 * method for types
	 */

	/**
	 *
	 * @return
	 */
	List<Type> getTypes();

	void addType(Type type);
	
	Type getType(QName type);

	/*
	 * Method for elements
	 */
	List<Element> getElements();

	void addElement(Element elmt);

	Element getElement(QName element);

	/*
	 * Method for attributes
	 */
	List<Attribute> getAttributes();

	void addAttribute(Attribute attr);

	Attribute getAttribute(QName attr);


	/*
	 * method for namespace
	 */
	String getTargetNamespace();

	NamespaceContext getAllNamespaces();
	
	
	/**
	 * Add an import to this schema.
	 *
	 * @param importDef the import to be added
	 */
	public void addImport(Import importDef);

	/**
	 * Remove an import from this schema.
	 *
	 * @param importDef the import to be removed
	 * @return the removed Import
	 */
	public Import removeImport(Import importDef);

	/**
	 * Get the list of imports for the specified namespaceURI.
	 *
	 * @param namespaceURI the namespaceURI associated with the
	 * desired imports.
	 * @return a list of the corresponding imports, or null if
	 * there weren't any matching imports
	 */
	public List<Import> getImports(String namespaceURI);

	/**
	 * Get a map of lists containing all the imports defined here.
	 * The map's keys are the namespaceURIs, and the map's values
	 * are lists. There is one list for each namespaceURI for which
	 * imports have been defined.
	 */
	public List<Import> getImports();

	/**
	 * Add an include to this schema.
	 *
	 * @param includeDef the include to be added
	 * @throws SchemaException 
	 */
	public void addInclude(Include includeDef) throws SchemaException;

	/**
	 * Remove an include from this schema.
	 *
	 * @param includeDef the include to be removed
	 * @return the removed include
	 * @throws SchemaException 
	 */
	public Include removeInclude(Include includeDef) throws SchemaException;

	/**
	 * Get the list of includes for the specified locationURI.
	 *
	 * @param locationURI the locationURI associated with the
	 * desired includes.
	 * @return a list of the corresponding includes, or null if
	 * there weren't any matching includes
	 */
	public List<Include> getIncludes(String locationURI);

	/**
	 * Get a map of lists containing all the includes defined here.
	 * The map's keys are the namespaceURIs, and the map's values
	 * are lists. There is one list for each locationURI for which
	 * imports have been defined.
	 */
	public List<Include> getIncludes();

	
	/**
	 * Set the document base URI of this definition. Can be used to
	 * represent the origin of the Definition, and can be exploited
	 * when resolving relative URIs (e.g. in &lt;import&gt;s).
	 *
	 * @param documentBaseURI the document base URI of this definition
	 */
	public void setDocumentBaseURI(URI documentBaseURI);

	/**
	 * Get the document base URI of this definition.
	 *
	 * @return the document base URI
	 */
	public URI getDocumentBaseURI();
	
	/**
	 * get the schema location
	 * @return
	 */
	Map<String, String> getSchemaLocation();

}
