/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.commons.schema.api.abstractElmt;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import org.xml.sax.InputSource;

import com.ebmwebsourcing.commons.schema.api.Include;
import com.ebmwebsourcing.commons.schema.api.Schema;
import com.ebmwebsourcing.commons.schema.api.SchemaException;
import com.ebmwebsourcing.commons.schema.api.SchemaReader;
import com.ebmwebsourcing.commons.schema.api.XmlException;
import com.ebmwebsourcing.commons.schema.api.SchemaReader.FeatureConstants;
import com.ebmwebsourcing.commons.schema.util.SourceHelper;
import com.ebmwebsourcing.commons.schema.util.Util;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class AbstractInclude<E> extends AbstractSchemaElement<E> implements Include  {

	private static Logger log = Logger.getLogger(AbstractInclude.class.getName());

	/**
	 * the schema
	 */
	protected Schema schema;

	/**
	 * the parent description
	 */
	protected Schema parent;

	/**
	 * Default constructor
	 * @param model the model
	 * @param parent the parent description
	 */
	public AbstractInclude(URI baseURI, E model, Map<FeatureConstants, Object> features) {
		this.model = model;
		this.parent = null;

		String location = this.getLocationURI() ;

		if((!Util.isURL(location))&&(baseURI != null)) {
			location = baseURI.getPath() + location;
		}

		if(features != null) {
			Object obj = features.get(FeatureConstants.IMPORT_DOCUMENTS);
			if((Boolean) obj) {
				retrieveInclude(location, features);
			}
		}



		if(schema != null) {
			((AbstractSchema)this.schema).setFeatures(features);
		}

	}

	/**
	 * Default constructor
	 * @param model the model
	 * @param parent the parent description
	 */
	public AbstractInclude(E model, Schema parent) {
		this.model = model;
		this.parent = parent;

		String location = this.getLocationURI() ;

		if((!Util.isURL(location))&&(parent.getDocumentBaseURI() != null)) {
			location = parent.getDocumentBaseURI().getPath() + location;
		}
		
		if(this.parent != null) {
			if(((AbstractSchema)this.parent).getFeatures() != null) {
				if((Boolean) ((AbstractSchema)this.parent).getFeatures().get(FeatureConstants.IMPORT_DOCUMENTS)) {
					retrieveInclude(location, ((AbstractSchema)this.parent).getFeatures());
				}
			}
		}

		if((parent != null)&&(schema != null)) {
			((AbstractSchema)this.schema).setFeatures(((AbstractSchema)this.parent).getFeatures());
		}
	}

	private void retrieveInclude(String location, Map<FeatureConstants, Object> features) {
		InputStream is = null;

		if (location != null) {

			try {
				URI loc = new URI(location);
				
				final File f = new File(location);
				if (f.exists()) {
					is = new FileInputStream(f);
				} else {
					is = loc.toURL().openStream();
				}

				SchemaReader reader = new com.ebmwebsourcing.commons.schema.impl.SchemaReader();

				((AbstractSchemaReader)reader).setFeatures(features);
				this.schema = reader.readSchema(loc, SourceHelper.convertInputSource2DOMSource(new InputSource(is)));

			} catch (final MalformedURLException e) {
				// do nothing
				// the document is not included in imported document
				AbstractInclude.log.warning("the imported document cannot be import at: " + location + " => " + e.getMessage());
			} catch (final URISyntaxException e) {
				// do nothing
				// the document is not included in imported document
				AbstractInclude.log.warning("the imported document cannot be import at: " + location + " => " + e.getMessage());
			} catch (final UnknownHostException e) {
				// do nothing
				// the document is not included in imported document
				AbstractInclude.log.warning("the imported document cannot be import at: " + location + " => " + e.getMessage());
			} catch (final ConnectException e) {
				// do nothing
				// the document is not included in imported document
				AbstractInclude.log.warning("the imported document cannot be import at: " + location + " => " + e.getMessage());
			} catch (final IllegalArgumentException e) {
				// do nothing
				// the document is not included in imported document
				AbstractInclude.log.warning("the imported document cannot be import at: " + location + " => " + e.getMessage());
			} catch (IOException e) {
				// do nothing
				// the document is not included in imported document
				AbstractInclude.log.warning("the imported document cannot be import at: " + location + " => " + e.getMessage());
			} catch (SchemaException e) {
				// do nothing
				// the document is not included in imported document
				e.printStackTrace();
				AbstractInclude.log.warning("the imported document cannot be import at: " + location + " => " + e.getMessage());
			} catch (XmlException e) {
				// do nothing
				// the document is not included in imported document
				e.printStackTrace();
				AbstractInclude.log.warning("the imported document cannot be import at: " + location + " => " + e.getMessage());
			}
		}
	}

	/**
	 * @return the schema
	 */
	public Schema getSchema() {
		return this.schema;
	}

	public void setSchema(Schema schema) {
		this.schema = schema;
	}

	/**
	 * @return the parent schema
	 */
	public Schema getParentSchema() {
		return parent;
	}

	public void setParentSchema(Schema parent) {
		this.parent = parent;
	}


}
