/**
 * easySchema - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.commons.schema.api.abstractElmt;

import java.util.ArrayList;
import java.util.List;

import org.jdom.output.XMLOutputter;
import org.w3._2001.xmlschema.Annotated;


import com.ebmwebsourcing.commons.schema.api.Attribute;
import com.ebmwebsourcing.commons.schema.api.Element;
import com.ebmwebsourcing.commons.schema.api.Schema;
import com.ebmwebsourcing.commons.schema.api.SchemaException;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class AbstractType<E extends Annotated, V> extends AbstractSchemaElement implements
		com.ebmwebsourcing.commons.schema.api.Type {

	/**
	 * the shema
	 */
	protected Schema schema;

	/**
	 * the outputter
	 */
	protected XMLOutputter outputter = new XMLOutputter();


	/**
	 * the list of attributes
	 */
	protected List<Attribute> attributes;


	/**
	 *
	 * @param model
	 * @param schema
	 */
	public AbstractType(E model, Schema schema) {
		this.model = model;
		this.schema = schema;

		outputter.setIndent("  "); // use two space indent
		outputter.setNewlines(true);
	}

	public abstract String printXml(Element e, V value) throws SchemaException;


	/*
	 * Attributes methods
	 */

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.commons.schema.api.Schema#getAttributes()
	 */
	public List<Attribute> getAttributes() {
		if(this.attributes == null) {
			this.attributes = new ArrayList<Attribute>();
		}
		return this.attributes;
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.commons.schema.api.Schema#getAttribute(javax.xml.namespace.QName)
	 */
	public Attribute getAttribute(String element) {
		Attribute res = null;
		if(attributes == null) {
			this.attributes = new ArrayList<Attribute>();
		}
		for (Attribute e : this.attributes) {
			if(e.getName().equals(element)) {
				res = e;
				break;
			}
		}
		return res;
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.commons.schema.api.Schema#addAttribute(com.ebmwebsourcing.commons.schema.api.Attribute)
	 */
	public void addAttribute(Attribute elmt) {
		if(attributes == null) {
			this.attributes = new ArrayList<Attribute>();
		}
		this.attributes.add(elmt);
	}
	
	public String toString() {
		String res = "anonymous type";
		if(this.getQName() != null) {
			res = this.getQName().toString();
		}
		return res;
	}
}
