/**
 * easySchema - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.commons.schema.api.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class NamespaceContext implements javax.xml.namespace.NamespaceContext {

	/**
	 * Map: key = prefix - value = namespaceUri
	 */
	public Map<String, String> ns = new HashMap<String, String>();

	public String getNamespaceURI(String prefix) {
		return ns.get(prefix);
	}

	public String getPrefix(String namespaceURI) {
		String res = null;
		for (Entry<String, String> entry: ns.entrySet()) {
			if(entry.getValue().equals(namespaceURI)) {
				res = entry.getKey();
				break;
			}
		}
		return res;
	}

	public Iterator getPrefixes(String namespaceURI) {
		List<String> res = new ArrayList<String>();
		for (Entry<String, String> entry: ns.entrySet()) {
			if(entry.getValue().equals(namespaceURI)) {
				res.add(entry.getKey());
			}
		}
		return res.iterator();
	}

	public void addNamespace(String prefix, String namespaceUri) {
		this.ns.put(prefix, namespaceUri);
	}
	
	public Map<String, String> getNamespaces() {
		return this.ns;
	}

	public String toString() {
		StringBuffer res = new StringBuffer();
		for (Entry<String, String> entry: ns.entrySet()) {
			res.append("xmlns:");
			res.append(entry.getKey());
			res.append("=");
			res.append(entry.getValue());
			res.append(" \n");
		}
		return res.toString();
	}
}
