/**
 * easySchema - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.commons.schema.impl;

import java.util.List;

import javax.xml.namespace.QName;

import org.w3._2001.xmlschema.Annotated;
import org.w3._2001.xmlschema.ComplexType.AttributeOrAttributeGroupItem;
import org.w3._2001.xmlschema.Group.ParticleItem;

import com.ebmwebsourcing.commons.schema.api.Attribute;
import com.ebmwebsourcing.commons.schema.api.Element;
import com.ebmwebsourcing.commons.schema.api.Schema;
import com.ebmwebsourcing.commons.schema.api.SchemaException;
import com.ebmwebsourcing.commons.schema.api.abstractElmt.AbstractAttribute;
import com.ebmwebsourcing.commons.schema.api.abstractElmt.AbstractElement;
import com.ebmwebsourcing.commons.schema.api.abstractElmt.AbstractType;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class ComplexType extends AbstractType<org.w3._2001.xmlschema.ComplexType, List<String>> implements
com.ebmwebsourcing.commons.schema.api.ComplexType {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	public ComplexType(org.w3._2001.xmlschema.ComplexType model, Schema schema) {
		super(model, schema);

		// get attributes associated to the elements
		for(AttributeOrAttributeGroupItem attr: model.getAttributeOrAttributeGroupItems()) {
			if(attr.getItemAttribute() != null) {
				Attribute a = new com.ebmwebsourcing.commons.schema.impl.Attribute(attr.getItemAttribute(), schema);
				this.addAttribute(a);
			}
		}
	}

	public QName getQName() {
		QName res = null;
		if(((org.w3._2001.xmlschema.ComplexType)this.getModel()).getName() != null) {
			res = new QName(this.schema.getTargetNamespace(), ((org.w3._2001.xmlschema.ComplexType)this.getModel()).getName());
		} 
		return res;
	}

	@Override
	public String printXml(Element eIn, List<String> values) throws SchemaException {
		org.jdom.Element eOut = ((AbstractElement)eIn).generateElement(values);
		return this.outputter.outputString(eOut);
	}

}
