/**
 * easySchema - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.commons.schema.impl;

import com.ebmwebsourcing.commons.schema.api.abstractElmt.AbstractSchemaElement;



/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class Documentation extends AbstractSchemaElement<org.w3._2001.xmlschema.Documentation> implements
		com.ebmwebsourcing.commons.schema.api.Documentation {


	public Documentation() {
		this.model = new org.w3._2001.xmlschema.Documentation();
	}

	public Documentation(org.w3._2001.xmlschema.Documentation doc) {
		this.model = doc;
	}

	public String getContent() {
		StringBuffer res = new StringBuffer();
		for (org.w3._2001.xmlschema.Documentation.ContentItem item : this.model.getContentItems()) {
			res.append(item.getText());
		}
		return res.toString();
	}

	public void setContent(String content) {
		this.model.getContentItems().clear();
		org.w3._2001.xmlschema.Documentation.ContentItem contentItem = new org.w3._2001.xmlschema.Documentation.ContentItem();
		contentItem.setText(content);
		this.model.getContentItems().add(contentItem);
	}

}
