/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.commons.schema.util;

import com.ebmwebsourcing.commons.schema.api.XmlException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SourceHelper {
    private static final ThreadLocal<DocumentBuilder> documentBuilderThreadLocal = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                return documentBuilder;
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("Failed to create DocumentBuilder", e);
            }
        }
    };
    private static final ThreadLocal<Transformer> transformerWithoutXmlDeclarationThreadLocal = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                Properties props = new Properties();
                props.put("omit-xml-declaration", "yes");
                transformer.setOutputProperties(props);
                return transformer;
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException("Failed to create Transformer", e);
            }
        }
    };

    private SourceHelper() {
    }

    public static DOMSource createSource(Document document) {
        document.normalizeDocument();
        return new DOMSource(document);
    }

    public static Document createDocument(Source s) throws XmlException {
        try {
            Document document = documentBuilderThreadLocal.get().newDocument();
            DOMResult domResult = new DOMResult(document);
            transformerWithoutXmlDeclarationThreadLocal.get().transform(s, domResult);
            return document;
        }
        catch (TransformerException e) {
            throw new XmlException(e);
        }
    }

    public static DOMSource convertInputSource2DOMSource(InputSource inputSource) throws XmlException {
        DOMSource res = null;
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = db.parse(inputSource);
            res = new DOMSource(document);
        }
        catch (ParserConfigurationException e) {
            throw new XmlException(e);
        }
        catch (SAXException e) {
            throw new XmlException(e);
        }
        catch (IOException e) {
            throw new XmlException(e);
        }
        return res;
    }

    public static InputSource convertDOMSource2InputSource(DOMSource inputSource) throws XmlException {
        InputSource res = null;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(os);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(inputSource, streamResult);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            res = new InputSource(is);
        }
        catch (TransformerException e) {
            throw new XmlException(e);
        }
        return res;
    }

    public static DOMSource cloneSource(DOMSource input) throws XmlException {
        Document doc = SourceHelper.createDocument(input);
        return SourceHelper.createSource(doc);
    }
}

