/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.commons.schema.util;

import java.io.StringWriter;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtil {
    private static final ThreadLocal<Transformer> transformerWithoutXmlDeclarationThreadLocal = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                Properties props = new Properties();
                props.put("omit-xml-declaration", "yes");
                props.put("method", "xml");
                transformer.setOutputProperties(props);
                return transformer;
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException("Failed to create Transformer", e);
            }
        }
    };
    private static final ThreadLocal<Transformer> defaultTransformerThreadLocal = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                Properties props = new Properties();
                props.put("omit-xml-declaration", "no");
                props.put("method", "xml");
                transformer.setOutputProperties(props);
                return transformer;
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException("Failed to create Transformer", e);
            }
        }
    };

    public static String createStringFromDOMDocument(Node document) throws TransformerException {
        return XMLUtil.createStringFromDOMNode(document, false);
    }

    public static String createStringFromDOMNode(Node node) throws TransformerException {
        return XMLUtil.createStringFromDOMNode(node, true);
    }

    public static String createStringFromDOMNodeList(NodeList list) throws TransformerException {
        StringBuffer sb = new StringBuffer("");
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                sb.append(XMLUtil.createStringFromDOMNode(list.item(i)));
            }
        }
        return sb.toString();
    }

    public static String createStringFromDOMNode(Node node, boolean omitDeclaration) throws TransformerException {
        node.normalize();
        DOMSource source = new DOMSource(node);
        StringWriter out = new StringWriter();
        StreamResult resultStream = new StreamResult(out);
        if (omitDeclaration) {
            transformerWithoutXmlDeclarationThreadLocal.get().transform(source, resultStream);
        } else {
            defaultTransformerThreadLocal.get().transform(source, resultStream);
        }
        return out.toString();
    }
}

