/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl;

import java.util.Map;

import com.ebmwebsourcing.commons.wsdl.api.Description;
import com.ebmwebsourcing.commons.wsdl.api.WSDLException;
import com.ebmwebsourcing.commons.wsdl.api.WSDLReader;
import com.ebmwebsourcing.commons.wsdl.api.WSDLWriter;
import com.ebmwebsourcing.commons.wsdl.api.WSDLReader.FeatureConstants;

/**
 * This abstract class defines a factory API that enables applications to obtain
 * a WSDLFactory capable of producing new Definitions, new WSDLReaders, and new
 * WSDLWriters.
 * 
 * Some ideas used here have been shamelessly copied from the wonderful JAXP and
 * Xerces work.
 * 
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class WSDLFactory {

    /**
     * Get a new instance of a WSDLFactory. This method follows (almost) the
     * same basic sequence of steps that JAXP follows to determine the
     * fully-qualified class name of the class which implements WSDLFactory.
     * <p>
     * The steps in order are:
     * <ol>
     * <li>Check the property file
     * META-INF/services/javax.wsdl.factory.WSDLFactory.</li>
     * <li>Check the javax.wsdl.factory.WSDLFactory system property.</li>
     * <li>Check the lib/wsdl.properties file in the JRE directory. The key will
     * have the same name as the above system property.</li>
     * <li>Use the default class name provided by the implementation.</li>
     * </ol>
     * <p>
     * Once an instance of a WSDLFactory is obtained, invoke newDefinition(),
     * newWSDLReader(), or newWSDLWriter(), to create the desired instances.
     */
    public static WSDLFactory newInstance() throws WSDLException {
        return new WSDLFactoryImpl();
    }

    /**
     * Create a new instance of a Definition.
     */
    public abstract Description newDescription();

    /**
     * Create a new instance of a WSDLReaderImpl.
     */
    public abstract WSDLReader newWSDLReader();

    /**
     * Create a new instance of a WSDLReaderImpl.
     */
    public abstract WSDLReader newWSDLReader(Map<FeatureConstants, Object> features);

    /**
     * Create a new instance of a WSDLWriterImpl.
     */
    public abstract WSDLWriter newWSDLWriter();

}
