/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.api;

import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.commons.wsdl.api.Binding.StyleConstant;
import com.ebmwebsourcing.commons.wsdl.util.Constants.SOAPMEPConstants;

/**
 * This interface represents a WSDL operation binding. That is, it holds the
 * information that would be specified in the operation element contained within
 * a binding element.
 * 
 * @author Nicolas Salatge - eBM WebSourcing
 */
public interface BindingOperation extends WSDLElement {

    /**
     * Set the name of this operation binding.
     * 
     * @param name
     *            the desired name
     */
    void setQName(QName name);

    /**
     * Get the name of this operation binding.
     * 
     * @return the operation binding name
     */
    QName getQName();

    /**
     * Set the operation that this operation binding binds.
     * 
     * @param operation
     *            the operation this operation binding binds
     */
    void setOperation(Operation operation);

    /**
     * Get the operation that this operation binding binds.
     * 
     * @return the operation that this operation binding binds
     */
    Operation getOperation();

    /**
     * Set the input message specification for this operation.
     * 
     * @param input
     *            the new input message
     */
    void setInput(BindingInput input);

    /**
     * Get the input message specification for this operation.
     * 
     * @return the input message
     */
    BindingInput getInput();

    /**
     * Set the output message specification for this operation.
     * 
     * @param output
     *            the new output message
     */
    void setOutput(BindingOutput output);

    /**
     * Get the output message specification for this operation.
     * 
     * @return the output message specification for the operation
     */
    BindingOutput getOutput();

    /**
     * Add a fault binding.
     * 
     * @param bindingFault
     *            the new fault binding
     */
    void addFault(BindingFault bindingFault);

    /**
     * Remove a fault binding.
     * 
     * @param name
     *            the name of the fault binding to be removed
     * @return the BindingFaultImpl which was removed
     */
    BindingFault removeFault(String name);

    /**
     * Get the specified fault binding.
     * 
     * @param name
     *            the name of the desired fault binding.
     * @return the corresponding fault binding, or null if there wasn't any
     *         matching fault binding
     */
    BindingFault getFault(String name);

    /**
     * Get all the fault bindings associated with this operation binding.
     * 
     * @return names of fault bindings
     */
    List<BindingFault> getFaults();

    /**
     * get the mep
     */
    SOAPMEPConstants getMEP();

    /**
     * set the mep
     * 
     * @param mep
     *            the mep
     */
    void setMEP(SOAPMEPConstants mep);

    /**
     * get style
     */
    StyleConstant getStyle();

    /**
     * get the soap action
     * 
     * @return
     */
    String getSoapAction();

    /*
     * http attribute for WSDL 2.0
     */

    /**
     * get the http location
     * 
     * @return
     */
    String getHttpLocation();

    String getHttpMethod();

    String getHttpInputSerialization();

    String getHttpOutputSerialization();

    String getHttpFaultSerialization();

    String getHttpQueryParameterSeparator();

    String getHttpContentEncodingDefault();

    boolean isHttpIgnoreUncited();

}
