/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.api;

import com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.http.HTTPBinding4Wsdl11;
import com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.mime.MIMEBinding4Wsdl11;
import com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.soap.soap11.SOAP11Binding4Wsdl11;
import com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.soap.soap12.SOAP12Binding4Wsdl11;
import com.ebmwebsourcing.commons.wsdl.api.binding.wsdl20.http.HTTPBinding4Wsdl20;
import com.ebmwebsourcing.commons.wsdl.api.binding.wsdl20.soap.SOAPBinding4Wsdl20;

/**
 * This interface represents an input message, and contains the name of the
 * input and the message itself.
 * 
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract interface BindingParam extends WSDLElement {

    /**
     * Set the name of this input.
     * 
     * @param name
     *            the desired name
     * @throws WSDLException
     */
    void setName(String name) throws WSDLException;

    /**
     * Get the name of this input.
     * 
     * @return the input message name
     */
    String getName();

    SOAP11Binding4Wsdl11 getSOAP11Binding4Wsdl11();

    SOAP12Binding4Wsdl11 getSOAP12Binding4Wsdl11();

    HTTPBinding4Wsdl11 getHTTPBinding4Wsdl11();

    MIMEBinding4Wsdl11 getMIMEBinding4Wsdl11();

    SOAPBinding4Wsdl20 getSOAP12Binding4Wsdl20();

    HTTPBinding4Wsdl20 getHTTPBinding4Wsdl20();

    String getHttpContentEncoding();
}
