/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.api;

import java.util.List;

import javax.xml.namespace.QName;

/**
 * This interface represents a port type. It contains information about
 * operations associated with this port type.
 * 
 * @author Nicolas Salatge - eBM WebSourcing
 */
public interface InterfaceType extends WSDLElement {
    /**
     * Set the name of this port type.
     * 
     * @param name
     *            the desired name
     */
    void setQName(QName name);

    /**
     * Get the name of this port type.
     * 
     * @return the port type name
     */
    QName getQName();

    /**
     * Add an operation to this port type.
     * 
     * @param operation
     *            the operation to be added
     */
    void addOperation(Operation operation);

    /**
     * Get the specified operation. Note that operation names can be overloaded
     * within a PortType.
     * 
     * @param name
     *            the name of the desired operation.
     * @return the corresponding operation, or null if there wasn't any matching
     *         operation
     * 
     * @throws IllegalArgumentException
     *             if duplicate operations are found.
     */
    Operation getOperation(QName name);

    /**
     * Get all the operations defined here.
     */
    List<Operation> getOperations();

    /**
     * Remove the specified operation. Note that operation names can be
     * overloaded within a PortType.
     * 
     * @param name
     *            the name of the desired operation.
     * 
     * @throws IllegalArgumentException
     *             if duplicate operations are found.
     * 
     * @see #getOperation(String)
     */
    Operation removeOperation(String name);

}
