/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.api;

import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.commons.schema.api.Element;

/**
 * This interface represents an input message, and contains the name of the
 * input and the message itself.
 * 
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract interface Param extends WSDLElement {

    /**
     * Set the name of this input.
     * 
     * @param name
     *            the desired name
     * @throws WSDLException
     */
    void setName(String name) throws WSDLException;

    /**
     * Get the name of this input.
     * 
     * @return the input message name
     */
    String getName();

    /**
     * Set the name of this input message.
     * 
     * @param name
     *            the desired name
     */
    void setMessageName(QName name);

    /**
     * Get the name of this input message.
     * 
     * @return the input message name
     */
    QName getMessageName();

    void setElement(Element element);

    Element getElement();

    List<Part> getParts();

    Part getPart(String name);

}
