/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.api;

import java.util.List;

import javax.xml.namespace.QName;

/**
 * This interface represents a service, which groups related endpoints to
 * provide some functionality.
 * 
 * @author Nicolas Salatge - eBM WebSourcing
 */
public interface Service extends WSDLElement {
    /**
     * Set the name of this service.
     * 
     * @param name
     *            the desired name
     */
    void setQName(QName name);

    /**
     * Get the name of this service.
     * 
     * @return the service name
     */
    QName getQName();

    /**
     * Add a endpoint to this service.
     * 
     * @param endpoint
     *            the endpoint to be added
     */
    void addEndpoint(Endpoint endpoint);

    /**
     * Get the specified endpoint.
     * 
     * @param name
     *            the name of the desired endpoint.
     * @return the corresponding endpoint, or null if there wasn't any matching
     *         endpoint
     */
    Endpoint getEndpoint(String name);

    /**
     * Remove the specified endpoint.
     * 
     * @param name
     *            the name of the endpoint to be removed.
     * @return the endpoint which was removed.
     */
    Endpoint removeEndpoint(String name);

    /**
     * Get all the endpoints defined here.
     */
    List<Endpoint> getEndpoints();

    /**
     * Get interface.
     */
    InterfaceType getInterface() throws WSDLException;
}
