/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.api.abstractElmt;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.commons.wsdl.api.Binding;
import com.ebmwebsourcing.commons.wsdl.api.BindingOperation;
import com.ebmwebsourcing.commons.wsdl.api.Description;
import com.ebmwebsourcing.commons.wsdl.api.InterfaceType;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class AbstractBindingImpl<E> extends AbstractWSDLElementImpl<E> implements Binding {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    /**
     * the desc
     */
    protected Description desc;

    /**
     * the associated interface
     */
    protected InterfaceType itf;

    /**
     * the list of binding operations
     */
    protected List<BindingOperation> bindingOperations = new ArrayList<BindingOperation>();

    /**
     * @return the desc
     */
    public Description getDescription() {
        return this.desc;
    }

    public InterfaceType getInterface() {
        return this.itf;
    }

    public List<BindingOperation> getBindingOperations() {
        if (this.bindingOperations == null) {
            this.bindingOperations = new ArrayList<BindingOperation>();
        }
        return this.bindingOperations;
    }

    public void addBindingOperation(final BindingOperation bo) {
        if (this.bindingOperations == null) {
            this.bindingOperations = new ArrayList<BindingOperation>();
        }
        this.bindingOperations.add(bo);
    }

    public BindingOperation getBindingOperation(final String name) {
        BindingOperation res = null;
        for (final BindingOperation bo : this.bindingOperations) {
            if (bo.getQName().getLocalPart().equals(name)) {
                res = bo;
                break;
            }
        }
        return res;
    }
}
