/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.api.abstractElmt;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.logging.Logger;

import org.xml.sax.InputSource;

import com.ebmwebsourcing.commons.schema.api.XmlException;
import com.ebmwebsourcing.commons.schema.util.SourceHelper;
import com.ebmwebsourcing.commons.schema.util.Util;
import com.ebmwebsourcing.commons.wsdl.api.Description;
import com.ebmwebsourcing.commons.wsdl.api.Include;
import com.ebmwebsourcing.commons.wsdl.api.WSDLException;
import com.ebmwebsourcing.commons.wsdl.api.WSDLReader;
import com.ebmwebsourcing.commons.wsdl.api.WSDLReader.FeatureConstants;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class AbstractIncludeImpl<E> extends AbstractWSDLElementImpl<E> implements Include {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    private static Logger log = Logger.getLogger(AbstractIncludeImpl.class.getName());

    /**
     * the desc
     */
    protected Description desc;

    /**
     * the parent description
     */
    protected Description parent;

    /**
     * Default constructor
     * 
     * @param model
     *            the model
     * @param parent
     *            the parent description
     */
    @SuppressWarnings("unchecked")
    public AbstractIncludeImpl(final E model, final Description parent) {
        this.model = model;
        this.parent = parent;

        String location = this.getLocationURI();

        if ((!Util.isURL(location)) && (parent.getDocumentBaseURI() != null)) {
            location = parent.getDocumentBaseURI().getPath() + location;
        }

        if (this.parent != null) {
            if (((AbstractDescriptionImpl) this.parent).getFeatures() != null) {
                if ((Boolean) ((AbstractDescriptionImpl) this.parent).getFeatures().get(
                        FeatureConstants.IMPORT_DOCUMENTS)) {
                    this.retrieveInclude(location);
                }
            }
        }

        if ((this.parent != null) && (this.desc != null)) {
            ((AbstractDescriptionImpl) this.desc)
                    .setFeatures(((AbstractDescriptionImpl) this.parent).getFeatures());
        }
    }

    @SuppressWarnings("unchecked")
    private void retrieveInclude(final String location) {
        if (location != null) {

            InputStream is = null;
            try {

                final URI loc = new URI(location);

                final File f = new File(location);
                if (f.exists()) {
                    is = new FileInputStream(new File(location));
                } else {
                    is = loc.toURL().openStream();
                }

                WSDLReader reader = null;
                if (this.parent instanceof com.ebmwebsourcing.commons.wsdl.impl.wsdl11.DescriptionImpl) {
                    reader = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.WSDLReaderImpl();
                } else if (this.parent instanceof com.ebmwebsourcing.commons.wsdl.impl.wsdl20.DescriptionImpl) {
                    reader = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.WSDLReaderImpl();
                }

                if (reader != null) {
                    ((AbstractWSDLReaderImpl) reader)
                            .setFeatures(((AbstractDescriptionImpl) this.parent).getFeatures());
                    this.desc = reader.readWSDL(loc, SourceHelper
                            .convertInputSource2DOMSource(new InputSource(is)));
                }

            } catch (final MalformedURLException e) {
                // do nothing
                // the document is not included in imported document
                AbstractIncludeImpl.log.warning("the imported document cannot be import at: "
                        + location + " => " + e.getMessage());
            } catch (final URISyntaxException e) {
                // do nothing
                // the document is not included in imported document
                AbstractIncludeImpl.log.warning("the imported document cannot be import at: "
                        + location + " => " + e.getMessage());
            } catch (final UnknownHostException e) {
                // do nothing
                // the document is not included in imported document
                AbstractIncludeImpl.log.warning("the imported document cannot be import at: "
                        + location + " => " + e.getMessage());
            } catch (final ConnectException e) {
                // do nothing
                // the document is not included in imported document
                AbstractIncludeImpl.log.warning("the imported document cannot be import at: "
                        + location + " => " + e.getMessage());
            } catch (final IllegalArgumentException e) {
                // do nothing
                // the document is not included in imported document
                AbstractIncludeImpl.log.warning("the imported document cannot be import at: "
                        + location + " => " + e.getMessage());
            } catch (final IOException e) {
                // do nothing
                // the document is not included in imported document
                AbstractIncludeImpl.log.warning("the imported document cannot be import at: "
                        + location + " => " + e.getMessage());
            } catch (final WSDLException e) {
                // do nothing
                // the document is not included in imported document
                AbstractIncludeImpl.log.warning("the imported document cannot be import at: "
                        + location + " => " + e.getMessage());
            } catch (final XmlException e) {
                // do nothing
                // the document is not included in imported document
                AbstractIncludeImpl.log.warning("the imported document cannot be import at: "
                        + location + " => " + e.getMessage());
            }
        }
    }

    /**
     * @return the desc
     */
    public Description getDescription() {
        return this.desc;
    }

    public void setDescription(final Description desc) {
        this.desc = desc;
    }

    /**
     * @return the parent desc
     */
    public Description getParentDescription() {
        return this.parent;
    }

    public void setParentDescription(final Description parent) {
        this.parent = parent;
    }

}
