
package com.ebmwebsourcing.commons.wsdl.api.abstractElmt;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.commons.wsdl.api.Description;
import com.ebmwebsourcing.commons.wsdl.api.InterfaceType;
import com.ebmwebsourcing.commons.wsdl.api.Operation;

/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class AbstractInterfaceTypeImpl<E> extends AbstractWSDLElementImpl<E> implements
        InterfaceType {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    /**
     * the desc
     */
    protected Description desc;

    /**
     * list of operations
     */
    protected List<Operation> operations = new ArrayList<Operation>();

    public void addOperation(final Operation op) {
        if (this.operations == null) {
            this.operations = new ArrayList<Operation>();
        }
        this.operations.add(op);
    }

    public Operation getOperation(final QName name) {
        Operation res = null;
        for (final Operation op : this.operations) {
            if (op.getQName().equals(name)) {
                res = op;
                break;
            }
        }
        return res;
    }

    public List<Operation> getOperations() {
        if (this.operations == null) {
            this.operations = new ArrayList<Operation>();
        }
        return this.operations;
    }

    /**
     * @return the desc
     */
    public Description getDescription() {
        return this.desc;
    }

}
