/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.api.abstractElmt;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.commons.wsdl.api.Fault;
import com.ebmwebsourcing.commons.wsdl.api.Input;
import com.ebmwebsourcing.commons.wsdl.api.InterfaceType;
import com.ebmwebsourcing.commons.wsdl.api.Operation;
import com.ebmwebsourcing.commons.wsdl.api.Output;
import com.ebmwebsourcing.commons.wsdl.api.Part;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class AbstractOperationImpl<E> extends AbstractWSDLElementImpl<E> implements
        Operation {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    /**
     * the parent interface
     */
    protected InterfaceType itf;

    /**
     * the input
     */
    protected Input input;

    /**
     * the output
     */
    protected Output output;

    /**
     * the faults
     */
    protected List<Fault> faults = new ArrayList<Fault>();

    /**
     * @return the interface
     */
    public InterfaceType getInterface() {
        return this.itf;
    }

    /**
     * @return the input
     */
    public Input getInput() {
        return this.input;
    }

    /**
     * @param input
     *            the input to set
     */
    public void setInput(final Input input) {
        this.input = input;
    }

    /**
     * @return the output
     */
    public Output getOutput() {
        return this.output;
    }

    /**
     * @param output
     *            the output to set
     */
    public void setOutput(final Output output) {
        this.output = output;
    }

    /**
     * @return the fault
     */
    public List<Fault> getFaults() {
        if (this.faults == null) {
            this.faults = new ArrayList<Fault>();
        }
        return this.faults;
    }

    /**
     * @param fault
     *            the fault to set
     */
    public void setFaults(final List<Fault> fault) {
        this.faults = fault;
    }

    public Fault getFault(final String name) {
        Fault res = null;
        for (final Fault f : this.faults) {
            if (f.getMessageName().getLocalPart().equals(name)) {
                res = f;
                break;
            }
        }
        return res;
    }

    public String getSignature() {
        String res = null;

        // get the output
        String returnS = "void";
        if (this.getOutput() != null) {
            if (this.getOutput().getElement() != null) {
                if (this.getOutput().getElement().getType().getQName() != null) {
                    returnS = this.getOutput().getElement().getType().getQName().toString();
                } else {
                    returnS = this.getOutput().getElement().getQName().toString();
                }
            } else if (this.getOutput().getParts() != null) {
                if (this.getOutput().getParts().size() == 1) {
                    if (this.getOutput().getParts().get(0).getElement() != null) {
                        if (this.getOutput().getParts().get(0).getElement().getType().getQName() != null) {
                            returnS = this.getOutput().getParts().get(0).getElement().getType()
                                    .getQName().toString();
                        } else {
                            returnS = this.getOutput().getParts().get(0).getElement().getQName()
                                    .toString();
                        }
                    } else if (this.getOutput().getParts().get(0).getType() != null) {
                        returnS = this.getOutput().getParts().get(0).getType().getQName()
                                .toString();
                    }
                } else {
                    returnS = "{";
                    for (final Part part : this.getOutput().getParts()) {
                        if (part.getElement() != null) {
                            if (part.getElement().getType().getQName() != null) {
                                returnS = returnS
                                        + part.getElement().getType().getQName().toString() + " ;";
                            } else {
                                returnS = returnS + part.getType().getQName().toString() + " ;";
                            }
                        } else if (part.getType() != null) {
                            returnS = returnS + part.getType().getQName().toString() + " ;";
                        }
                    }
                    returnS = returnS + "}";
                    returnS = returnS.replace(";}", "}");
                }
            }
        }

        // get the operation name
        final String operation = this.getQName().toString();

        // get the input parameters
        String params = "(";
        if (this.getInput() != null) {
            if (this.getInput().getElement() != null) {
                if (this.getInput().getElement().getType().getQName() != null) {
                    params = params + this.getInput().getElement().getType().getQName().toString()
                            + " " + this.getInput().getElement().getQName().toString();
                } else {
                    params = params + this.getInput().getElement().getQName().toString();
                }
            } else if (this.getInput().getParts() != null) {
                for (final Part part : this.getInput().getParts()) {
                    if (part.getElement() != null) {
                        if (part.getElement().getType().getQName() != null) {
                            params = params + part.getElement().getType().getQName().toString()
                                    + " " + part.getElement().getQName().toString() + " ,";
                        } else {
                            params = params + part.getElement().getQName().toString() + " ,";
                        }
                    } else if (part.getType() != null) {
                        params = params + part.getType().getQName().toString() + " "
                                + part.getPartQName() + " ,";
                    }
                }
            }
        }
        params = params + ")";
        params = params.replace(",)", ")");

        // create signature
        res = returnS + " " + operation + params;
        return res;
    }
}
