/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.api.abstractElmt;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.commons.wsdl.api.Endpoint;
import com.ebmwebsourcing.commons.wsdl.api.Service;
import com.ebmwebsourcing.commons.wsdl.api.Description;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class AbstractServiceImpl<E> extends AbstractWSDLElementImpl<E> implements Service {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    /**
     * the desc
     */
    protected Description desc;

    /**
     * list of endpoints
     */
    protected List<Endpoint> endpoints = new ArrayList<Endpoint>();

    public void addEndpoint(final Endpoint endpoint) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<Endpoint>();
        }
        this.endpoints.add(endpoint);
    }

    public Endpoint getEndpoint(final String name) {
        Endpoint res = null;
        for (final Endpoint ep : this.endpoints) {
            if (ep.getName().equals(name)) {
                res = ep;
                break;
            }
        }
        return res;
    }

    public List<Endpoint> getEndpoints() {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<Endpoint>();
        }
        return this.endpoints;
    }

    /**
     * @return the desc
     */
    public Description getDescription() {
        return this.desc;
    }

}
