/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.api.abstractElmt;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import javax.xml.XMLConstants;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

import com.ebmwebsourcing.commons.schema.api.Import;
import com.ebmwebsourcing.commons.schema.api.Schema;
import com.ebmwebsourcing.commons.wsdl.api.Description;
import com.ebmwebsourcing.commons.wsdl.api.Types;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class AbstractTypesImpl<E> extends AbstractWSDLElementImpl<E> implements Types {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    /**
     * the desc
     */
    protected Description desc;

    /**
     * the list of schemas
     */
    protected List<Schema> schemas = new ArrayList<Schema>();

    /**
     * the list of imported schemas
     */
    protected List<com.ebmwebsourcing.commons.schema.api.Import> importedSchemas = new ArrayList<Import>();

    @SuppressWarnings("unchecked")
    protected List<Document> getSchemaDocuments() {
        final List<Document> res = new ArrayList<Document>();
        final Element types = ((AbstractDescriptionImpl) this.desc).getDocument().getRootElement()
                .getChild(
                        "types",
                        Namespace.getNamespace(((AbstractDescriptionImpl) this.desc).getVersion()
                                .toString()));

        if (types != null) {
            for (final Element schemaOrImport : (List<Element>) types.getChildren()) {
                if ((schemaOrImport.getName().equals("schema"))
                        && (schemaOrImport.getNamespace().equals(Namespace
                                .getNamespace(XMLConstants.W3C_XML_SCHEMA_NS_URI)))) {
                    res.add(new Document((Element) schemaOrImport.clone()));
                } else if ((schemaOrImport.getName().equals("import"))
                        && (schemaOrImport.getNamespace().equals(Namespace
                                .getNamespace(XMLConstants.W3C_XML_SCHEMA_NS_URI)))) {
                    for (final Import impt : this.importedSchemas) {
                        if (impt.getLocationURI().equals(
                                schemaOrImport.getAttributeValue("schemaLocation"))) {
                            res
                                    .add(((com.ebmwebsourcing.commons.schema.api.abstractElmt.AbstractSchema) ((com.ebmwebsourcing.commons.schema.api.abstractElmt.AbstractImport) impt)
                                            .getSchema()).getDocument());
                        }
                    }
                }
            }
        }
        return res;
    }

    protected void addImportedSchemasInAllList() {
        for (final Import impt : this.importedSchemas) {
            if (impt.getSchema() != null) {
                this.schemas.add(impt.getSchema());
            }
        }
    }

    public List<Schema> getSchemas() {
        if (this.schemas == null) {
            this.schemas = new ArrayList<Schema>();
        }
        return this.schemas;
    }

    public List<Import> getImportedSchemas() {
        if (this.importedSchemas == null) {
            this.importedSchemas = new ArrayList<Import>();
        }
        return this.importedSchemas;
    }

    protected void setAllNamespacesInAllSchemas() {
        for (final Schema schema : this.schemas) {
            final Map<String, String> ns = ((com.ebmwebsourcing.commons.schema.api.extensions.NamespaceContext) this.desc
                    .getNamespaces()).getNamespaces();
            for (final Entry<String, String> entry : ns.entrySet()) {
                ((com.ebmwebsourcing.commons.schema.api.extensions.NamespaceContext) schema
                        .getAllNamespaces()).addNamespace(entry.getKey(), entry.getValue());
            }
        }
    }

}
