/*
 * (c) Copyright IBM Corp 2006
 */

package com.ebmwebsourcing.commons.wsdl.api.abstractElmt;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import org.w3.ns.wsdl.DocumentedType;
import org.w3.ns.wsdl.ExtensibleDocumentedType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xmlsoap.schemas.wsdl.TDocumented;
import org.xmlsoap.schemas.wsdl.TExtensibleAttributesDocumented;
import org.xmlsoap.schemas.wsdl.TExtensibleDocumented;
import org.xmlsoap.schemas.wsdl.TExtensibleDocumented.AnyItem;

import com.ebmwebsourcing.commons.schema.api.XmlException;
import com.ebmwebsourcing.commons.schema.util.SourceHelper;
import com.ebmwebsourcing.commons.wsdl.api.Documentation;
import com.ebmwebsourcing.commons.wsdl.api.WSDLElement;
import com.ebmwebsourcing.commons.wsdl.api.WSDLException;
import com.ebmwebsourcing.commons.wsdl.util.Constants;

/**
 * Abstract super class for all WSDL Elements, providing some basic
 * common functionality.
 */
/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class AbstractWSDLElementImpl<E> implements WSDLElement {
    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    /**
     * the model
     */
    protected E model;

    protected Documentation documentation;


    /**
     * Set the documentation for this document.
     * 
     * @param docEl
     *            the documentation element
     */
    @SuppressWarnings("unchecked")
    public void setDocumentation(final Documentation doc) {
        this.documentation = doc;

        if (this.model instanceof TDocumented) {
            ((TDocumented) this.model)
            .setDocumentation(((com.ebmwebsourcing.commons.wsdl.impl.wsdl11.DocumentationImpl) this.documentation)
                    .getModel());
        } else if (this.model instanceof List) {
            ((List<DocumentedType>) this.model)
            .add((DocumentedType) ((com.ebmwebsourcing.commons.wsdl.impl.wsdl20.DocumentationImpl) this.documentation)
                    .getModel());
        }
    }

    /**
     * Get the documentation.
     * 
     * @return the documentation element
     */
    public Documentation getDocumentation() {
        return this.documentation;
    }

    /**
     * Create the documentation element.
     * 
     * @return the documentation element
     */
    public Documentation createDocumentation() {
        Documentation doc = null;
        if (this.getClass().getPackage().getName().equals(Constants.WSDL11_PACKAGE)) {
            doc = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.DocumentationImpl();
        } else if (this.getClass().getPackage().getName().equals(Constants.WSDL20_PACKAGE)) {
            doc = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.DocumentationImpl();
        }
        return doc;
    }

    /**
     * Get all the extensibility elements defined here.
     * @throws WSDLException 
     */
    @SuppressWarnings("unchecked")
    public List<Element> getOtherElements() throws WSDLException {
        List<Element> res = new ArrayList<Element>();

        if (this.model instanceof TExtensibleDocumented) {
            List<AnyItem> any = null;
            any = ((TExtensibleDocumented)this.model).getAnyItems();
            String xmlElmt = null;
            for (AnyItem anyItem : any) {
                xmlElmt = anyItem.getItemElement();
                res.add(createElementFromString(xmlElmt));
            }
        } 
        return res;
    }

    protected Element createElementFromString(String xmlElmt) throws WSDLException {
        Document doc = null;
        try {
            doc = SourceHelper.createDocument(SourceHelper.convertInputSource2DOMSource(new InputSource(new ByteArrayInputStream(xmlElmt.getBytes()))));
        } catch (XmlException e) {
            throw new WSDLException(e);
        }
        return doc.getDocumentElement();
    }

    /**
     * Get the map containing all the attributes defined on this
     * element. The keys are the qnames of the attributes.
     * 
     * @return a map containing all the attributes defined on this
     *         element
     * @throws WSDLException 
     * 
     */
    public Map<QName, String> getOtherAttributes() throws WSDLException {
        Map<QName, String> res = new HashMap<QName, String>();

        if (this.model instanceof TExtensibleAttributesDocumented) {
            res = ((TExtensibleAttributesDocumented)this.model).getOtherAttributes();
        } else if (this.model instanceof ExtensibleDocumentedType) {
            res =  ((ExtensibleDocumentedType)this.model).getOtherAttributes();
        }
        return res;
    }

    @Override
    public String toString() {
        return this.model.toString();
    }


    public E getModel() {
        return this.model;
    }
}
