/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.api.abstractElmt;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import com.ebmwebsourcing.commons.wsdl.api.WSDLReader;
import com.ebmwebsourcing.commons.wsdl.util.WSDLJDomAnalyzer;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class AbstractWSDLReaderImpl implements WSDLReader {

    private static Logger log = Logger.getLogger(AbstractWSDLReaderImpl.class.getName());

    private Map<FeatureConstants, Object> features = new HashMap<FeatureConstants, Object>();

    // analyze wsdl
    protected WSDLJDomAnalyzer analyzer;

    public AbstractWSDLReaderImpl() {
        this.features.put(FeatureConstants.VERBOSE, false);
        this.features.put(FeatureConstants.IMPORT_DOCUMENTS, true);
    }

    /**
     * @return the analyzer
     */
    public WSDLJDomAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    /**
     * @param analyzer
     *            the analyzer to set
     */
    public void setAnalyzer(final WSDLJDomAnalyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void setFeature(final FeatureConstants name, final Object value) throws IllegalArgumentException {
        this.features.put(name, value);
        AbstractWSDLReaderImpl.log.finest("set proterty: " + name + " - value = " + value);
    }

    public Object getFeature(final FeatureConstants name) throws IllegalArgumentException {
        return this.features.get(name);
    }

    public Map<FeatureConstants, Object> getFeatures() {
        return this.features;
    }

    public void setFeatures(final Map<FeatureConstants, Object> features) {
        this.features = features;
    }
}
