/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.generic;

import org.apache.commons.lang.NotImplementedException;
import org.w3.ns.wsdl.DescriptionType;
import org.w3c.dom.Document;
import org.xmlsoap.schemas.wsdl.TDefinitions;

import com.ebmwebsourcing.commons.wsdl.api.Description;
import com.ebmwebsourcing.commons.wsdl.api.WSDLException;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractWSDLElementImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WSDLWriterImpl implements com.ebmwebsourcing.commons.wsdl.api.WSDLWriter {

    public Document getDocument(final Description wsdlDef) throws WSDLException {
        Document doc = null;

        final com.ebmwebsourcing.commons.wsdl.api.WSDLWriter writer = this.getConcreteWriter(wsdlDef);
        doc = writer.getDocument(wsdlDef);
        return doc;
    }

    @SuppressWarnings("unchecked")
    private com.ebmwebsourcing.commons.wsdl.api.WSDLWriter getConcreteWriter(final Description wsdlDef)
            throws WSDLException {
        com.ebmwebsourcing.commons.wsdl.api.WSDLWriter writer = null;
        if ((wsdlDef != null)
                && (((AbstractWSDLElementImpl) wsdlDef).getModel() instanceof TDefinitions)) {
            writer = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.WSDLWriterImpl();
        } else if ((wsdlDef != null)
                && (((AbstractWSDLElementImpl) wsdlDef).getModel() instanceof DescriptionType)) {
            writer = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.WSDLWriterImpl();
        } else {
            throw new WSDLException("Unknown model");
        }
        return writer;
    }

    public boolean getFeature(final String name) throws IllegalArgumentException {
        throw new NotImplementedException();
    }

    public void setFeature(final String name, final boolean value) throws IllegalArgumentException {
        throw new NotImplementedException();
    }

    public String writeWSDL(final Description wsdlDef) throws WSDLException {
        String res = null;
        final com.ebmwebsourcing.commons.wsdl.api.WSDLWriter writer = this.getConcreteWriter(wsdlDef);
        res = writer.writeWSDL(wsdlDef);
        return res;
    }

}
