/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl11;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.xmlsoap.schemas.wsdl.TBinding;
import org.xmlsoap.schemas.wsdl.TBindingOperation;

import com.ebmwebsourcing.commons.wsdl.api.BindingOperation;
import com.ebmwebsourcing.commons.wsdl.api.InterfaceType;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractBindingImpl;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractWSDLElementImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class BindingImpl extends AbstractBindingImpl<TBinding> implements
        com.ebmwebsourcing.commons.wsdl.api.Binding {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    public BindingImpl(final TBinding binding, final DescriptionImpl desc) {
        this.model = binding;
        this.desc = desc;

        // get the documentation
        this.documentation = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.DocumentationImpl(
                this.model.getDocumentation());

        // get the interface
        final QName itfName = this.model.getType();
        this.itf = this.desc.getInterface(itfName);

        // get the binding operations
        for (final TBindingOperation tbo : this.model.getOperation()) {
            final BindingOperation bo = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.BindingOperationImpl(
                    tbo, this);
            this.bindingOperations.add(bo);
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    public void addBindingOperation(final BindingOperation bindingOperation) {
        super.addBindingOperation(bindingOperation);
        this.model.getOperation().add(
                (TBindingOperation) ((AbstractWSDLElementImpl) bindingOperation).getModel());
    }

    public QName getQName() {
        return new QName(this.desc.getTargetNamespace(), this.model.getName());
    }

    public BindingOperation removeBindingOperation(final String name) {
        throw new NotImplementedException();
    }

    public void setInterface(final InterfaceType interfaceType) {
        throw new NotImplementedException();
    }

    public void setQName(final QName name) {
        throw new NotImplementedException();
    }

    @SuppressWarnings("unchecked")
    public String getTransportProtocol() {
        String protocol = null;
        for (final Object element : this.model.getAny()) {
            if (((JAXBElement) element).getValue() instanceof org.xmlsoap.schemas.wsdl.soap.TBinding) {
                protocol = ((org.xmlsoap.schemas.wsdl.soap.TBinding) ((JAXBElement) element)
                        .getValue()).getTransport();
                break;
            }
            if (((JAXBElement) element).getValue() instanceof org.xmlsoap.schemas.wsdl.soap12.TBinding) {
                protocol = ((org.xmlsoap.schemas.wsdl.soap12.TBinding) ((JAXBElement) element)
                        .getValue()).getTransport();
                break;
            }
            if (((JAXBElement) element).getValue() instanceof org.xmlsoap.schemas.wsdl.http.BindingType) {
                protocol = ((org.xmlsoap.schemas.wsdl.http.BindingType) ((JAXBElement) element)
                        .getValue()).getVerb();
                break;
            }
        }
        return protocol;
    }

    public void setTransportProtocol() {
        throw new NotImplementedException();
    }

    @SuppressWarnings("unchecked")
    public StyleConstant getStyle() {
        StyleConstant style = null;
        for (final Object element : this.model.getAny()) {
            if (((JAXBElement) element).getValue() instanceof org.xmlsoap.schemas.wsdl.soap.TBinding) {
                if (((org.xmlsoap.schemas.wsdl.soap.TBinding) ((JAXBElement) element).getValue())
                        .getStyle() != null) {
                    style = StyleConstant
                            .valueOf(((org.xmlsoap.schemas.wsdl.soap.TBinding) ((JAXBElement) element)
                                    .getValue()).getStyle().value().toUpperCase());
                }
                break;
            }
            if (((JAXBElement) element).getValue() instanceof org.xmlsoap.schemas.wsdl.soap12.TBinding) {
                if (((org.xmlsoap.schemas.wsdl.soap12.TBinding) ((JAXBElement) element).getValue())
                        .getStyle() != null) {
                    style = StyleConstant
                            .valueOf(((org.xmlsoap.schemas.wsdl.soap12.TBinding) ((JAXBElement) element)
                                    .getValue()).getStyle().value().toUpperCase());
                }
                break;
            }
        }
        return style;
    }

    @SuppressWarnings("unchecked")
    public BindingConstants getTypeOfBinding() {
        BindingConstants res = null;
        for (final Object element : this.model.getAny()) {
            if (((JAXBElement) element).getValue() instanceof org.xmlsoap.schemas.wsdl.soap.TBinding) {
                res = BindingConstants.SOAP11_BINDING4WSDL11;
                break;
            }
            if (((JAXBElement) element).getValue() instanceof org.xmlsoap.schemas.wsdl.soap12.TBinding) {
                res = BindingConstants.SOAP12_BINDING4WSDL11;
                break;
            }
            if (((JAXBElement) element).getValue() instanceof org.xmlsoap.schemas.wsdl.http.BindingType) {
                res = BindingConstants.HTTP11_BINDING4WSDL11;
                break;
            }
        }
        return res;
    }

    public String getVersion() {
        String res = null;
        if (this.getTypeOfBinding().equals(BindingConstants.SOAP11_BINDING4WSDL11)) {
            res = "1.1";
        } else if (this.getTypeOfBinding().equals(BindingConstants.SOAP12_BINDING4WSDL11)) {
            res = "1.2";
        } else if (this.getTypeOfBinding().equals(BindingConstants.HTTP11_BINDING4WSDL11)) {
            res = "1.1";
        }
        return res;
    }

    public String getHttpContentEncodingDefault() {
        return null;
    }

    public String getHttpDefaultMethod() {
        return null;
    }

    public String getHttpQueryParameterSeparatorDefault() {
        return null;
    }

    public boolean isHttpCookies() {
        return false;
    }

}
